% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmulti.R
\name{glmmulti}
\alias{glmmulti}
\title{Binomial logistic regression multivariable models: \code{finalfit} model
wrapper}
\usage{
glmmulti(.data, dependent, explanatory, family = "binomial", ...)
}
\arguments{
\item{.data}{Data frame.}

\item{dependent}{Character vector of length 1: name of depdendent variable
(must have 2 levels).}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{family}{Character vector quoted or unquoted of the error distribution
and link function to be used in the model, see \code{\link[stats]{glm}}.}

\item{...}{Other arguments to pass to \code{\link[stats]{glm}}.}
}
\value{
A multivariable \code{\link[stats]{glm}} fitted model.
}
\description{
Using \code{finalfit} conventions, produces a multivariable binomial
logistic regression model for a set of explanatory variables against a
binary dependent.
}
\details{
Uses \code{\link[stats]{glm}} with \code{finalfit} modelling conventions.
Output can be passed to \code{\link{fit2df}}.
}
\examples{
library(finalfit)
library(dplyr)
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"

colon_s \%>\%
	glmmulti(dependent, explanatory) \%>\%
	fit2df(estimate_suffix=" (univariable)")

}
\seealso{
\code{\link{fit2df}, \link{finalfit_merge}}

Other finalfit model wrappers: \code{\link{coxphmulti}},
  \code{\link{coxphuni}}, \code{\link{crrmulti}},
  \code{\link{crruni}}, \code{\link{glmmixed}},
  \code{\link{glmmulti_boot}}, \code{\link{glmuni}},
  \code{\link{lmmixed}}, \code{\link{lmmulti}},
  \code{\link{lmuni}}, \code{\link{svyglmmulti}},
  \code{\link{svyglmuni}}
}
\concept{finalfit model wrappers}
