% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_freq_compare}
\alias{fst_freq_compare}
\title{Compare and plot top words}
\usage{
fst_freq_compare(
  data1,
  data2,
  data3 = NULL,
  data4 = NULL,
  number = 10,
  norm = "number_words",
  pos_filter = NULL,
  name1 = "Group 1",
  name2 = "Group 2",
  name3 = "Group 3",
  name4 = "Group 4",
  unique_colour = "indianred",
  strict = TRUE
)
}
\arguments{
\item{data1}{A dataframe of text in CoNLL-U format for the first plot.}

\item{data2}{A dataframe of text in CoNLL-U format for the second plot.}

\item{data3}{An optional dataframe of text in CoNLL-U format for the third
plot, default is `NULL`.}

\item{data4}{An optional dataframe of text in CoNLL-U format for the fourth
plot, default is `NULL`.}

\item{number}{The number of top words to return, default is `10`.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses, default),
`"number_resp"` (the number of responses), or `NULL` (raw count returned).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{name1}{An optional "name" for the first plot, default is `"Group 1"`.}

\item{name2}{An optional "name" for the second plot, default is `"Group 2"`.}

\item{name3}{An optional "name" for the third plot, default is `"Group 3"`.}

\item{name4}{An optional "name" for the fourth plot, default is `"Group 4"`.}

\item{unique_colour}{Colour to display unique words, default is
`"indianred"`.}

\item{strict}{Whether to strictly cut-off at `number` (ties are
alphabetically ordered), default is `TRUE`.}
}
\value{
Between 2 and 4 plots of Top n-grams in the plots pane with unique
n-grams highlighted.
}
\description{
Find top and unique top words for between 2 and 4 sets of prepared data.
Results will be shown within the plots pane. If 2 or 3 plots, they will be in
a single row, if there are 4 plots, they will be in 2 rows of 2.
}
\examples{
f <- conllu_dev_q11_1_f_nltk
m <- conllu_dev_q11_1_m_nltk
na <- conllu_dev_q11_1_na_nltk
fst_freq_compare(f, m, number = 10)
fst_freq_compare(f, m, na, number = 5, norm = "number_resp")
fst_freq_compare(f, m, na, name1 = "F", name2 = "M", name3 = "NA")
fst_freq_compare(f, m, na, strict = FALSE)
}
