% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_summarise_compare}
\alias{fst_summarise_compare}
\title{Make comparison summary}
\usage{
fst_summarise_compare(
  data1,
  data2,
  data3 = NULL,
  data4 = NULL,
  name1 = "Group 1",
  name2 = "Group 2",
  name3 = "Group 3",
  name4 = "Group 4"
)
}
\arguments{
\item{data1}{A dataframe of text in CoNLL-U format for the first group.}

\item{data2}{A dataframe of text in CoNLL-U format for the second group.}

\item{data3}{An optional dataframe of text in CoNLL-U format for the third
group, default is `NULL`.}

\item{data4}{An optional dataframe of text in CoNLL-U format for the fourth
group, default is `NULL`.}

\item{name1}{A string describing data1, default is `"Group 1"`.}

\item{name2}{A string describing data2, default is `"Group 2"`.}

\item{name3}{A string describing data3, default is `"Group 3"`.}

\item{name4}{A string describing data4, default is `"Group 4"`.}
}
\value{
Summary table of responses between groups.
}
\description{
Compare text responses for between 2 and 4 sets of prepared data.
}
\examples{
f <- conllu_dev_q11_1_f_nltk
m <- conllu_dev_q11_1_m_nltk
na <- conllu_dev_q11_1_na_nltk
all <- conllu_dev_q11_1_nltk
fst_summarise_compare(m, f, na, all, "Male", "Female", "Not Spec.", "All")
fst_summarise_compare(m, f, name1 = "Male", name2 = "Female")
}
