% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GHGbeta.R
\name{pGHGBeta}
\alias{pGHGBeta}
\title{Gaussian Hypergeometric Generalized Beta Distribution}
\usage{
pGHGBeta(p,n,a,b,c)
}
\arguments{
\item{p}{vector of probabilities}

\item{n}{single value for no of binomial trials}

\item{a}{single value for shape parameter alpha representing as a}

\item{b}{single value for shape parameter beta representing as b}

\item{c}{single value for shape parameter lambda representing as c}
}
\value{
The output of \code{pGHGBeta} gives the cumulative density values in vector form.
}
\description{
These functions provide the ability for generating probability density values,
cumulative probability density values and moment about zero values for the
Gaussian Hypergeometric Generalized Beta distribution bounded between [0,1]
}
\details{
The probability density function and cumulative density function of a unit bounded
Gaussian Hypergeometric Generalized Beta Distribution with random variable P are given by

\deqn{g_{P}(p)= \frac{1}{B(a,b)}\frac{2F1(-n,a;-b-n+1;1)}{2F1(-n,a;-b-n+1;c)} p^{a-1}(1-p)^{b-1} \frac{c^{b+n}}{(c+(1-c)p)^{a+b+n}} };
\eqn{0 \le p \le 1}
\deqn{G_{P}(p)= \int^p_0 \frac{1}{B(a,b)}\frac{2F1(-n,a;-b-n+1;1)}{2F1(-n,a;-b-n+1;c)} t^{a-1}(1-t)^{b-1}\frac{c^{b+n}}{(c+(1-c)t)^{a+b+n}} \,dt } ;
\eqn{0 \le p \le 1}
\deqn{a,b,c > 0}
\deqn{n = 1,2,3,...}

The mean and the variance are denoted by
\deqn{E[P]= \int^1_0 \frac{p}{B(a,b)}\frac{2F1(-n,a;-b-n+1;1)}{2F1(-n,a;-b-n+1;c)} p^{a-1}(1-p)^{b-1}\frac{c^{b+n}}{(c+(1-c)p)^{a+b+n}} \,dp }
\deqn{var[P]= \int^1_0 \frac{p^2}{B(a,b)}\frac{2F1(-n,a;-b-n+1;1)}{2F1(-n,a;-b-n+1;c)} p^{a-1}(1-p)^{b-1}\frac{c^{b+n}}{(c+(1-c)p)^{a+b+n}} \,dp - (E[p])^2}

The moments about zero is denoted as
\deqn{E[P^r]= \int^1_0 \frac{p^r}{B(a,b)}\frac{2F1(-n,a;-b-n+1;1)}{2F1(-n,a;-b-n+1;c)} p^{a-1}(1-p)^{b-1}\frac{c^{b+n}}{(c+(1-c)p)^{a+b+n}} \,dp}
\eqn{r = 1,2,3,...}

Defined as \eqn{B(a,b)} as the beta function
Defined as \eqn{2F1(a,b;c;d)} as the Gaussian Hypergeometric function


\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col<-rainbow(5)
a<-c(.1,.2,.3,1.5,2.15)
plot(0,0,main="Proability density graph",xlab="Random variable",ylab="Proabiility density values",
xlim = c(0,1),ylim = c(0,10))
for (i in 1:5)
{
lines(seq(0,1,by=0.001),dGHGBeta(seq(0,1,by=0.001),7,1+a[i],0.3,1+a[i])$pdf,col = col[i])
}
dGHGBeta(seq(0,1,by=0.01),7,1.6312,0.3913,0.6659)$pdf   #extracting the pdf values
dGHGBeta(seq(0,1,by=0.01),7,1.6312,0.3913,0.6659)$mean  #extracting the mean
dGHGBeta(seq(0,1,by=0.01),7,1.6312,0.3913,0.6659)$var   #extracting the variance

#plotting the random variables and cumulative probability values
col<-rainbow(6)
a<-c(.1,.2,.3,1.5,2.1,3)
plot(0,0,main="Cumulative density graph",xlab="Random variable",ylab="Cumulative density values",
xlim = c(0,1),ylim = c(0,1))
for (i in 1:6)
{
lines(seq(0.01,1,by=0.001),pGHGBeta(seq(0.01,1,by=0.001),7,1+a[i],0.3,1+a[i]),col=col[i])
}

pGHGBeta(seq(0,1,by=0.01),7,1.6312,0.3913,0.6659) #acquiring the cumulative probability values
mazGHGBeta(1.4,7,1.6312,0.3913,0.6659)            #acquiring the moment about zero values

#acquiring the variance for a=1.6312,b=0.3913,c=0.6659
mazGHGBeta(2,7,1.6312,0.3913,0.6659)-mazGHGBeta(1,7,1.6312,0.3913,0.6659)^2
#only the integer value of moments is taken here because moments cannot be decimal
mazGHGBeta(1.9,15,5,6,1)

}
\references{
Rodriguez-Avi, J., Conde-Sanchez, A., Saez-Castillo, A. J., & Olmo-Jimenez, M. J. (2007). A generalization
of the beta-binomial distribution. Journal of the Royal Statistical Society. Series C (Applied Statistics), 56(1), 51-61.

Available at : \url{http://dx.doi.org/10.1111/j.1467-9876.2007.00564.x}

Pearson, J., 2009. Computation of Hypergeometric Functions. Transformation, (September), p.1--123.
}
\seealso{
\code{\link[hypergeo]{hypergeo_powerseries}}
}
