% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPx.R
\name{getPx}
\alias{getPx}
\title{Extract Px from fitted objects}
\usage{
getPx(object, x = 50, coverage = 0.95)
}
\arguments{
\item{object}{Object returned by \code{\link{fitplc}}}

\item{x}{The x in Px, that is, if P50 should be returned, x=50.}

\item{coverage}{The desired coverage of the confidence interval (0.95 is the default).}
}
\description{
Extract esimates of Px from an object returned by \code{\link{fitplc}}. This allows extraction of estimates of P88 or other values when the fit estimated P50 (or other), for example. When the Weibull model is used, it is especially recommended to fit the P50 and estimate other points of the curve with \code{getPx}. 

See examples for use of this function. Note that the confidence interval is based on the bootstrap resampling performed by \code{\link{fitplc}}. This function only works when \code{bootci=TRUE} when the curve was fit.
}
\details{
Note that this function does not return a standard error, because the bootstrap confidence interval will be rarely symmetrical. If you like, you can calculate it as the mean of the half CI width (and note it as an 'approximate standard error'). A better approach is to only report the CI and not the SE.

Sometimes the upper CI cannot be calculated and will be reported as \code{NA}. This indicates that the upper confidence bound is outside the range of the data, and can therefore not be reliably reported. It is especially common when \code{x} is large, say for P88.
}
\examples{
# A fit
somefit <- fitplc(stemvul, x=50, model="sigmoid")

# Extract P12, P88
# Note NA for upper CI for P88; this is quite common
# and should be interpreted as falling outside the range of the data.
getPx(somefit, x=c(12,88))

}

