% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviates.R
\name{is_JP_ready}
\alias{is_JP_ready}
\title{Check whether a set of vectors obeys the constraints necessary to be used in
the Jolliffe-Primo flatness test}
\usage{
is_JP_ready(x, verbose = TRUE, tol = 1e-04)
}
\arguments{
\item{x}{an \code{rkhist} or matrix object containing the vectors to check
(by row).}

\item{verbose}{a logical. Should the result of the check be displayed?}

\item{tol}{a positive numeric. The accepted tolerance for the constraints.}
}
\value{
A list with entries
\describe{
\item{isOK}{TRUE if the set obeys the constraints, FALSE otherwise}
\item{tol}{the tolerance allowed on the constraints}
\item{crossprod}{the cross product of the vectors}
\item{sums}{the sum of the components of each vector}
\item{x}{the checked vectors}}
}
\description{
This function checks whether a set of vectors has the following two
properties:
\itemize{
\item the set is orthonormal
\item each vector has components summing to zero (that is, it is a deviation)
}
}
