% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_metrics.R
\name{performance}
\alias{performance}
\title{Compare performance of different models}
\usage{
performance(..., metrics = "all", metadata = FALSE, digits = 2)
}
\arguments{
\item{...}{Multiple model objects (only of class `modeler`).}

\item{metrics}{Can be "all" or a character vector of metrics to be computed
(one or more of "logLik", "AIC", "AICc", "BIC", "Sigma", "SSE", "MAE", "MSE", "RMSE", "R2").
"all" by default.}

\item{metadata}{Logical. If \code{TRUE}, metadata is included with the
performance metrics. Default is \code{FALSE}.}

\item{digits}{An integer. The number of decimal places to round the output. Default is 2.}
}
\value{
A data.frame with performance metrics for models in (...).
}
\description{
Computes indices of model performance for different models at once and hence
allows comparison of indices across models.
}
\examples{
library(flexFitR)
data(dt_potato)
# Model 1
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 90),
    subset = 40
  )
print(mod_1)
# Model 2
mod_2 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_logistic",
    parameters = c(a = 0.199, t0 = 47.7, k = 100),
    subset = 40
  )
print(mod_2)
# Model 3
mod_3 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin",
    parameters = c(m = 20, b = 2),
    subset = 40
  )
print(mod_3)
performance(mod_1, mod_2, mod_3, metrics = c("AIC", "AICc", "BIC", "Sigma"))
}
