% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf.R
\docType{data}
\name{flowopts}
\alias{flowopts}
\alias{opts_flow}
\alias{set_opts}
\alias{get_opts}
\alias{load_opts}
\alias{opts_flow$set}
\alias{opts_flow$get}
\alias{opts_flow$load}
\title{Default options/params used in flowr and ngsflows}
\format{
\code{opts_flow}

An object of class \code{list} of length 5.
}
\usage{
flowopts

get_opts(...)
set_opts(...)
load_opts(...)
}
\arguments{
\item{...}{\itemize{
\item get: names of options to fetch
\item set: a set of options in a name=value format separated by commas
}}
}
\description{
There are three helper functions which attempt to manage parameters used by flowr and ngsflows:
\itemize{
\item \link[params]{get_opts} OR \code{opts_flow\$get()}: show all default options
\item \link[params]{set_opts} OR \code{opts_flow\$set()}: set default options
\item \link[params]{load_opts} OR \code{opts_flow\$load()}: load options specified in a tab separated text file
}
For more details regarding these functions refer to \href{http://sahilseth.com/params/}{params} package.
}
\details{
By default flowr loads, \code{~/flowr/conf/flowr.conf} and \code{~/flowr/conf/ngsflows.conf}

Below is a list of default flowr options, retrieved via

\code{opts_flow$get()}:
\preformatted{
|name              |value                    |
|:-----------------|:------------------------|
|default_regex     |(.*)                     |
|flow_base_path    |~/flowr                  |
|flow_conf_path    |~/flowr/conf             |
|flow_parse_lsf    |.*(\<[0-9]*\>).*         |
|flow_parse_moab   |(.*)                     |
|flow_parse_sge    |(.*)                     |
|flow_parse_slurm  |(.*)                     |
|flow_parse_torque |(.?)\..*                 |
|flow_pipe_paths   |~/flowr/pipelines        |
|flow_pipe_urls    |~/flowr/pipelines        |
|flow_platform     |local                    |
|flow_run_path     |~/flowr/runs             |
|my_conf_path      |~/flowr/conf             |
|my_dir            |path/to/a/folder         |
|my_path           |~/flowr                  |
|my_tool_exe       |/usr/bin/ls              |
|time_format       |\%a \%b \%e \%H:\%M:\%S CDT \%Y |
|verbose           |FALSE                    |
}
}
\examples{
## Set options: opts_flow$set()
opts = opts_flow$set(flow_run_path = "~/mypath")
## OR if you would like to supply a long list of options:
opts = opts_flow$set(.dots = list(flow_run_path = "~/mypath"))

## load options from a configuration file: opts_flow$load()
conffile = fetch_conf("flowr.conf")
opts_flow$load(conffile)

## Fetch options: get_opts()
opts_flow$get("flow_run_path")
opts_flow$get()

}
\seealso{
\link{fetch} \link[params]{params} \link[params]{read_sheet}
}
\keyword{datasets}
