% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices-class.R
\name{CashIndex}
\alias{CashIndex}
\title{CashIndex class}
\usage{
CashIndex(name, currency, spot_lag, calendar, day_basis, day_convention)
}
\arguments{
\item{name}{the name of the index as a string}

\item{currency}{the currency associated with the index as a
\link[=Currency]{Currency} object}

\item{spot_lag}{the period between the index's fixing and the start of
the index's term}

\item{calendar}{the calendar used to determine whether the index fixes on a
given date as a \link[fmdates:Calendar]{Calendar}}

\item{day_basis}{the day basis associated with the index (e.g. "act/365")}

\item{day_convention}{the day convention associated with the index (e.g. "mf")}
}
\value{
an object of class \code{CashIndex} that inherits from \code{Index}
}
\description{
This can be used to represent ONIA like indices (e.g. AONIA, FedFunds)
and extends the \code{InterestRateIndex} class.
}
\examples{
library(lubridate)
library(fmdates)
# RBA cash overnight rate
CashIndex("AONIA", AUD(), days(0), c(AUSYCalendar()), "act/365", "f")
}
