% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices-class.R
\name{IborIndex}
\alias{IborIndex}
\title{IborIndex class}
\usage{
IborIndex(name, currency, tenor, spot_lag, calendar, day_basis, day_convention,
  is_eom)
}
\arguments{
\item{name}{the name of the index as a string}

\item{currency}{the currency associated with the index as a
\link[=Currency]{Currency} object}

\item{tenor}{the term of the index as a \link[lubridate:period]{period}}

\item{spot_lag}{the period between the index's fixing and the start of
the index's term}

\item{calendar}{the calendar used to determine whether the index fixes on a
given date as a \link[fmdates:Calendar]{Calendar}}

\item{day_basis}{the day basis associated with the index (e.g. "act/365")}

\item{day_convention}{the day convention associated with the index (e.g. "mf")}

\item{is_eom}{a flag indicating whether or not the maturity date of the index
is subject to the end-to-end convention.}
}
\value{
an object of class \code{IborIndex} that inherits from \code{Index}
}
\description{
This can be used to represent IBOR like indices (e.g. LIBOR, BBSW, CDOR)
and extends the \code{Index} class.
}
\examples{
library(lubridate)
library(fmdates)
# 3m AUD BBSW
IborIndex("BBSW", AUD(), months(3), days(0), c(AUSYCalendar()),
  "act/365", "ms", FALSE)
}
