% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullmds.R
\name{fullmds}
\alias{fullmds}
\title{Full Multidimensional Scaling Function}
\usage{
fullmds(
  delta,
  w = NULL,
  p = 2,
  z = NULL,
  r = NULL,
  b = NULL,
  level = c("none", "linear", "power", "box-cox", "spline", "ordinal"),
  anchor = TRUE,
  ninner = 0,
  degree = 2,
  knotstype = c("none", "uniform", "percentile", "midpercentile"),
  iknots = NULL,
  approach = 1,
  lambda = 0,
  alpha = 1,
  grouped = FALSE,
  MAXITER = 1024,
  FCRIT = 1e-08,
  ZCRIT = 1e-06,
  rotate = TRUE,
  faster = FALSE,
  error.check = FALSE,
  echo = FALSE
)
}
\arguments{
\item{delta}{an n by n squares hollow matrix containing dissimilarities.}

\item{w}{an identical sized matrix containing non-negative weights (all ones when omitted).}

\item{p}{dimensionality (default = 2).}

\item{z}{n by p matrix with initial coordinates.}

\item{r}{restrictions on the configuration,
either an n by p matrix with booleans indicating free (false) and fixed (true) coordinates
or an n by h numerical matrix with h independent variables.}

\item{b}{h by p matrix with initial regression coefficients.}

\item{level}{type of dissimilarity transformation}

\item{anchor}{boolean indicating the use of an intercept}

\item{ninner}{number of interior knots.}

\item{degree}{spline degree.}

\item{knotstype}{type of knots, either a vector with knots or the type uniform, percentile, or midpercentile.}

\item{iknots}{user-provided interior knots}

\item{approach}{approach to ties: 1 = untie ties, 2 = keep ties tied.}

\item{lambda}{regularization penalty parameter (default = 0.0: no penalty).}

\item{alpha}{elastic-net parameter (default = 1.0: lasso only).}

\item{grouped}{boolean for grouped lasso penalty (default = FALSE: ordinary lasso).}

\item{MAXITER}{maximum number of iterations (default = 1024).}

\item{FCRIT}{relative convergence criterion function value (default = 0.00000001).}

\item{ZCRIT}{absolute convergence criterion coordinates (default = 0.000001).}

\item{rotate}{if TRUE: solution is rotated to principal axes.}

\item{faster}{logical indicating faster but less precise procedure.}

\item{error.check}{extensive validity check input parameters (default = FALSE).}

\item{echo}{print intermediate algorithm results (default = FALSE).}
}
\value{
data original n by n matrix with dissimilarities.

weights original n by n matrix with weights.

transformed.data final n by n matrix with transformed dissimilarities.

anchor whether an intercept was used or not.

degree spline degree.

ninner number of interior knots.

knotstype type of procedure creating the interior knot sequence.

iknots interior knots sequence.

approach apporach to ties: 1 = untie ties, 2 = keep ties tied.

coordinates final n by p matrix with coordinates.

restriction either the fixed coordinates or the independent variables.

coefficients final h by p matrix with regression coefficients.

lambda (optimal) penalty parameter.

alpha elastic-net penalty parameter.

grouped common or grouped lasso penalty.

distances final n by n matrix with Euclidean distances between n rows of coordinates.

last.iteration final iteration number.

last.difference final function difference used for convergence testing.

n.stress final normalized stress value.

rotate if solution is rotated to principal axes.

faster if a faster procedure has been used.
}
\description{
\code{fullmds} performs a complete multidimensional scaling analysis.
The function follows algorithms given by de Leeuw and Heiser (1980).
The data, dissimilarities and weights, are either symmetric or asymmetric.
The dissimilarities are may contain negative values, the weights may not.
The configuration is either unrestricted, (partly) fixed,
or a linear combination of independent variables.
The dissimilarities may be transformed by different functions, with related parameters.
}
\examples{
data( "colors" )
delta <- as.matrix( ( colors )^3 )
n <- nrow( delta )
w <- 1 - diag( n )
p <- 2
zinit <- matrix( runif( n * p ), n, p )
r <- fullmds( delta = delta, w = w, p = p, z = zinit, echo = TRUE )
summary( r )
print( r )
plot( r )

}
\references{
de Leeuw, J., and Heiser, W. J. (1980). Multidimensional scaling with restrictions on the configuration.
            In P.R. Krishnaiah (Ed.), Multivariate analysis (Vol. 5, pp. 501–522).
            Amsterdam, The Netherlands: North-Holland Publishing Company.

            Heiser, W.J. (1991). A generalized majorization method for least squares multidimensional scaling of pseudo-distances that may be negative.
            Psychometrika, 55, pages 7-27.

            Busing, F.M.T.A. (submitted). Node Localization by Multidimensional Scaling with Iterative Majorization: A Psychometric Perspective.
            Signal Processing, Elsevier.
}
\author{
Frank M.T.A. Busing
}
