% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpmf.R
\name{mpmf}
\alias{mpmf}
\title{fit the move persistence model to regularized location data}
\usage{
mpmf(
  x,
  model = c("mpm", "jmpm"),
  optim = c("nlminb", "optim"),
  verbose = FALSE,
  control = NULL,
  inner.control = NULL
)
}
\arguments{
\item{x}{temporally regularized location data, eg. output from \code{fit_ssm}}

\item{model}{specify whether MPM is to be fit with unpooled ("mpm") or pooled ("jmpm") RW variance(s).}

\item{optim}{numerical optimizer to be used ("nlminb" or "optim")}

\item{verbose}{report progress during minimization}

\item{control}{list of control parameters for the outer optimization (type ?nlminb or ?optim for details)}

\item{inner.control}{list of control settings for the inner optimization
(see ?TMB::MakeADFUN for additional details)}
}
\description{
generates initial values for model parameters and unobserved gamma's;
structures data and initial values for C++ \code{TMB} template;
fits move persistence model; minimizes the joint log-likelihood via the selected
optimizer (\code{nlminb} or \code{optim}); structures and passes output
object to \code{fit_mpm}
}
\details{
called by \code{fit_mpm}, not intended for general use. see ?fit_mpm.
}
