% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_grob.r
\name{add_grob}
\alias{add_grob}
\title{Add grob in cells}
\usage{
add_grob(
  plot,
  row = NULL,
  col = NULL,
  part = c("body", "header"),
  order = c("top", "text", "background", "bottom"),
  gb_fn,
  ...
)
}
\arguments{
\item{plot}{A forest plot object.}

\item{row}{A numeric value or vector indicating row(s) to draw a grob.}

\item{col}{A numeric value or vector indicating the columns to draw a grob.}

\item{part}{The border will be added to \code{"body"} (default) or
\code{"header"}.}

\item{order}{Order in which the grobs should be plotted. Use \code{'top'}
(default) to draw the grob above everything, \code{'text'} on the top of text
given by plot data but below everything else, \code{'background'} plot on the
top of background but below everything else, \code{'bottom'} below everything.}

\item{gb_fn}{Grob function}

\item{...}{Other parameters to be passed to \code{gb_fn}.}
}
\value{
A \code{\link[gtable]{gtable}} object.
}
\description{
Draw grobs in any cells.
}
\seealso{
\code{\link[gtable]{gtable_add_grob}}
}
