context("casts")

test_that("cast_integer() works properly", {
  expect_identical(cast_integer(c(1, 2)), 1:2)
  expect_identical(cast_integer(42), 42L)
  expect_identical(cast_integer(NULL, allow_null = TRUE), NULL)
  expect_identical(cast_integer(c(2, NA), allow_na = TRUE), c(2L, NA))
  expect_identical(cast_integer(list(1, 2)), 1:2)
  expect_identical(cast_nullable_scalar_integer(42), 42L)
  expect_identical(cast_nullable_scalar_integer(NULL), NULL)
  expect_identical(cast_nullable_integer(NULL), NULL)
  expect_identical(cast_nullable_integer(42), 42L)
  expect_identical(cast_integer_list(1:3), as.list(1:3))
  expect_identical(cast_nullable_integer_list(NULL), NULL)
  expect_identical(cast_nullable_integer_list(1:3), as.list(1:3))

  expect_error(cast_integer(NULL), "`x` must not be NULL\\.")
  expect_error(cast_integer(1:3, 2), "`x` must be of length 2, but is of length 3\\.")
  expect_error(cast_integer(1.2), "Can't convert a fractional double vector to an integer vector")
  expect_error(cast_integer(NA), "`x` must not contain NAs\\.")
  expect_error(cast_integer(1:2, c(1, 2)), "`n` must be an integer\\.")
  expect_error(cast_scalar_integer(1:3), "`x` must be of length 1, but is of length 3\\.")
  expect_error(cast_scalar_integer(NULL), "`x` must not be NULL\\.")
  expect_error(cast_nullable_scalar_integer(1:3), "`x` must be of length 1, but is of length 3\\.")
})

test_that("cast_double() works properly", {
  expect_identical(cast_double(1:2), c(1, 2))
  expect_identical(cast_double(42.5), 42.5)
  expect_identical(cast_double(c(2.4, NA), allow_na = TRUE), c(2.4, NA))
  expect_identical(cast_double(NULL, allow_null = TRUE), NULL)
  expect_identical(cast_double(list(1, 2)), c(1, 2))
  expect_identical(cast_nullable_double(1:2), c(1, 2))
  expect_identical(cast_nullable_double(NULL), NULL)
  expect_identical(cast_nullable_scalar_double(42L), 42)
  expect_identical(cast_nullable_scalar_double(NULL), NULL)
  expect_identical(cast_double_list(1:3), list(1, 2, 3))
  expect_identical(cast_nullable_double_list(NULL), NULL)
  expect_identical(cast_nullable_double_list(1:3), list(1, 2, 3))

  expect_error(cast_double(NULL), "`x` must not be NULL\\.")
  expect_error(cast_double(1:3, 2), "`x` must be of length 2, but is of length 3\\.")
  expect_error(cast_double(NA), "`x` must not contain NAs\\.")
  expect_error(cast_scalar_double(c(1, 2)), "`x` must be of length 1, but is of length 2\\.")
  expect_error(cast_scalar_double(NULL), "`x` must not be NULL\\.")
  expect_error(cast_nullable_scalar_double(1:3), "`x` must be of length 1, but is of length 3\\.")
})

test_that("cast_character() works properly", {
  expect_identical(cast_character(c("foo", "bar")), c("foo", "bar"))
  expect_identical(cast_scalar_character("foo"), "foo")
  expect_identical(cast_character(NULL, allow_null = TRUE), NULL)
  expect_identical(cast_character(list("foo", "bar")), c("foo", "bar"))
  expect_identical(cast_nullable_character(NULL), NULL)
  expect_identical(cast_nullable_scalar_character(NULL), NULL)
  expect_identical(cast_string("foo"), "foo")
  expect_identical(cast_nullable_string(NULL), NULL)
  expect_identical(cast_character_list(c("foo", "bar")), list("foo", "bar"))
  expect_identical(cast_nullable_character_list(NULL), NULL)
  expect_identical(cast_nullable_character_list(c("foo", "bar")), list("foo", "bar"))

  expect_error(cast_scalar_character(c("foo", "bar")), "`x` must be of length 1, but is of length 2\\.")
  expect_error(cast_nullable_scalar_character(letters[1:3]), "`x` must be of length 1, but is of length 3\\.")
  expect_error(cast_string(c("foo", "bar")), "`x` must be of length 1, but is of length 2\\.")
  expect_identical(cast_string_list(c("foo", "bar")), list("foo", "bar"))
  expect_identical(cast_nullable_string_list(NULL), NULL)
  expect_identical(cast_nullable_string_list(c("foo", "bar")), list("foo", "bar"))
  expect_identical(cast_string(4), "4")
})

test_that("cast_choice() works properly", {
  expect_identical(cast_choice(2, 1:3), 2L)
  expect_identical(cast_choice(2, c(1, 2, 3)), 2)
  expect_identical(cast_choice("foo", c("foo", "bar")), "foo")
  expect_identical(cast_choice(NA, letters, allow_na = TRUE), NA)
  expect_identical(cast_choice(NULL, letters, allow_null = TRUE), NULL)

  expect_error(cast_choice(NA, letters), "`x` must not be NA\\.")
  expect_error(cast_choice(NULL, letters), "`x` must not be NULL\\.")
  expect_error(cast_choice("foo", c("bar", "baz")), "`x` must be one of bar, baz\\.")
  expect_error(cast_choice("foo", c(TRUE, FALSE)), "`choices` must be a vector of numbers or strings\\.")
})

test_that("cast_logical() works properly", {
  expect_identical(cast_logical(TRUE), TRUE)
  expect_identical(cast_logical(FALSE), FALSE)
  expect_identical(cast_logical(NULL, allow_null = TRUE), NULL)
  expect_identical(cast_nullable_scalar_logical(NULL), NULL)
  expect_identical(cast_nullable_logical(NULL), NULL)
  expect_identical(cast_nullable_logical(TRUE), TRUE)
  expect_identical(cast_logical_list(c(TRUE, FALSE)), list(TRUE, FALSE))
  expect_identical(cast_nullable_logical_list(NULL), NULL)
  expect_identical(cast_nullable_logical_list(c(TRUE, FALSE)), list(TRUE, FALSE))

  expect_error(cast_logical(0), "`x` must be a logical vector\\.")
  expect_error(cast_scalar_logical(c(TRUE, FALSE)),
               "`x` must be of length 1, but is of length 2\\.")
})
