% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page_size.R
\name{font_lcpi}
\alias{font_lcpi}
\title{Calculate lines per inch and characters per inch for font}
\usage{
font_lcpi(font_family = "Courier", font_size = 8, lineheight = 1)
}
\arguments{
\item{font_family}{(\code{string})\cr name of a font family. An error will be thrown
if the family named is not monospaced. Defaults to \code{"Courier"}.}

\item{font_size}{(\code{numeric(1)})\cr font size. Defaults to \code{12}.}

\item{lineheight}{(\code{numeric(1)})\cr line height. Defaults to \code{1}.}
}
\value{
A named list with \code{cpi} and \code{lpi}, the characters and lines per
inch, respectively.
}
\description{
Calculate lines per inch and characters per inch for font
}
\details{
This function opens a PDF graphics device, writes to a temporary file, then
utilizes \code{\link[grid:grid.convert]{grid::convertWidth()}} and \code{\link[grid:grid.convert]{grid::convertHeight()}} to calculate lines
per inch and characters per inch for the specified font family, size, and
line height.

An error is thrown if the font is not monospaced (determined by comparing
the effective widths of the \code{M} and \code{.} glyphs).
}
\examples{
font_lcpi <- getFromNamespace("font_lcpi", "formatters")

font_lcpi()
font_lcpi(font_size = 8)
font_lcpi(font_size = 8, lineheight = 1.1)

}
\keyword{internal}
