% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_Server.R
\name{FG_fetch_state}
\alias{FG_fetch_state}
\title{Fetch Figure Generation State}
\usage{
FG_fetch_state(
  id,
  input,
  session,
  FM_yaml_file,
  MOD_yaml_file,
  id_ASM = NULL,
  id_UD = NULL,
  id_DW = NULL,
  react_state
)
}
\arguments{
\item{id}{Shiny module ID}

\item{input}{Shiny input variable}

\item{session}{Shiny session variable}

\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id_ASM}{ID string for the app state management module used to save and load app states}

\item{id_UD}{ID string for the upload data module used to handle uploads or the name of the list element in react_state where the data set is stored.}

\item{id_DW}{ID string for the data wrangling module to process any uploaded data}

\item{react_state}{Variable passed to server to allow reaction outside of module (\code{NULL})}
}
\value{
list containing the current state of the app including default
values from the yaml file as well as any changes made by the user. The
structure of the list is defined below:
\itemize{
 \item{yaml:} Contents of the yaml file.
 \item{MC:} Module components of the yaml file.
 \item{FG:} Data wrangling state
 \itemize{
   \item{isgood:} Boolean status of the state. Currently just TRUE
   \item{button_counters:}  List of counters to detect button clicks.
   \item{ui_msg:}           Message returned when users perform actions.
   \item{ui:}               Current value of form elements in the UI.
   \item{ui_ids:}           Vector of UI elements for the module.
   \item{ui_hold:}          List of hold elements to disable updates before a full ui referesh is complete.
   \item{checksum:          checksum of the FG module used to detect changes in the module.}
   \item{aes_elements:}     Plot elements defined by aesthetics (i.e. the X in geom_X)
   \item{current_fig:}      fig_id of the currently figure.
   \item{fig_cntr:}         Counter for figures, incremented each time a new figure is created.
   \item{DSV:}              Available data sets from the UD and DW modules.
   \item{figs:}             List of figures. Each view has the following structure:
     \itemize{
       \item{add_isgood:    JMH}
       \item{checksum:       Checksum of the figure used to detect changes in the figure.}
       \item{code:           Code to generate figure from start to finish.}
       \item{code_fg_only:   Code to just generate the figure.}
       \item{code_previous:  Code to load and/or wrangle the dataset.}
       \item{elements_table: Table of figure generation elements.}
       \item{fg_object_name: JMH}
       \item{fig_dsview:     Name of the dataset view for the current figure (also the R object name of the dataset view).}
       \item{fobj:           JMH}
       \item{id:             Character id (\code{fig_idx})}
       \item{idx:            Numeric id (\code{1})}
       \item{isgood:}        Boolean status of the figure. FALSE if evaluation/build fails.
       \item{key:            Figure key acts as a title/caption (user editable)}
       \item{msgs:           JMH}
       \item{notes:          Figure notes  (user editable)}
       \item{num_pages:      JMH}
       \item{page:           JMH}
     }
 }
 \item{MOD_TYPE:} Character data containing the type of module \code{"DW"}
 \item{id:} Character data containing the module id module in the session variable.
 \item{FM_yaml_file:} App configuration file with FM as main section.
 \item{MOD_yaml_file:}  Module configuration file with MC as main section.
}
}
\description{
Merges default app options with the changes made in the UI
}
\examples{
# Configuration files
FM_yaml_file  = system.file(package = "formods", "templates", "formods.yaml")
MOD_yaml_file = system.file(package = "formods", "templates", "FG.yaml")

# We need to specify both the FG module id as well as the
# id of the UD module that feeds into it.
id    = "FG"
id_UD = "UD"
id_DW = "DW"

# These would be the Shiny input and session variables
input   = list()
session = list()

# Creating an empty state object
state = FG_fetch_state(id              = id,
                       input           = input,
                       session         = session,
                       FM_yaml_file    = FM_yaml_file,
                       MOD_yaml_file   = MOD_yaml_file,
                       id_UD           = id_UD,
                       id_DW           = id_DW,
                       react_state     = NULL)

state
}
