% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_generate_report}
\alias{FM_generate_report}
\title{Generate Report}
\usage{
FM_generate_report(
  state,
  session,
  file_dir,
  file_name,
  gen_code_only = FALSE,
  rpterrors = TRUE
)
}
\arguments{
\item{state}{Module state requesting the report generation}

\item{session}{Shiny session variable}

\item{file_dir}{path to the location where the file should be written.}

\item{file_name}{base_filename (acceptable extensions are xlsx, docx, or pptx).}

\item{gen_code_only}{Boolean value indicating that only code should be
generated (\code{FALSE}).}

\item{rpterrors}{Boolean variable to generate reports with errors.}
}
\value{
List with the following elements
}
\description{
Generates a report from the states of the different modules.
The type of report is based on the file extension of file_name.
}
\details{
This function will look through the loaded modules and find those with
 reporting enabbled. If reporting is enabled it will look for reporting functions
 for that module. Reporting functions should be of the following format
 (name and arguments):

   \code{XX_append_report(state, rpt, rpttype)}

  Where \code{XX} is the module short name. The state is the current state of the
  module. The rpt contains the current content of the report. This will
  vary based on the report type:

\itemize{
 \item{xlsx:} List with two elements. The first is \code{summary} a data
 frame with two columns. The first column is called \code{Sheet_Name} and
 the second column is called \code{Description}. This is a catalog of
 sheets added to the report by the user and can be appended to using rbind.
 The second element in xlsx rpt is another list with element names
 corresponding to the report sheet names and the values corresponding to
 dataframes to be exported in the report.
 \item{pptx or docx:} Corresponding onbrand reporting object.
}
}
\examples{
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = FG_test_mksession(session=list(), full_session=FALSE)
session = sess_res$session
input   = sess_res$input

# This will create a populated FG state object:
state   = sess_res$state


# This is the directory to write the report:
file_dir = tempdir()

# This is the file name that determines the type of report to write:
file_name = "my_report.pptx"

rpt_res =
FM_generate_report(state         = state,
                   session       = session,
                   file_dir      = file_dir,
                   file_name     = file_name,
                   gen_code_only = TRUE,
                   rpterrors     = TRUE)

# This contains the exit status of the report generation
rpt_res$isgood

# This is the underlying code that was used to generate the report
cat(paste0(rpt_res$code, collapse="\n"))
}
