% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UD_Server.R
\name{UD_preload}
\alias{UD_preload}
\title{Preload Data for UD Module}
\usage{
UD_preload(
  session,
  src_list,
  yaml_res,
  mod_ID = NULL,
  react_state = list(),
  quickload = FALSE
)
}
\arguments{
\item{session}{Shiny session variable (in app) or a list (outside of app)}

\item{src_list}{List of preload data (all read together with module IDs at the top level)}

\item{yaml_res}{List data from module yaml config}

\item{mod_ID}{Module ID of the module being loaded.}

\item{react_state}{Reactive shiny object (in app) or a list (outside of app) used to trigger reactions.}

\item{quickload}{Logical \code{TRUE} to load reduced analysis \code{FALSE} to load the full analysis}
}
\value{
list with the following elements
\itemize{
  \item{isgood:}      Boolean indicating the exit status of the function.
  \item{msgs:}        Messages to be passed back to the user.
  \item{session:}     Session object
  \item{input:}       The value of the shiny input at the end of the session initialization.
  \item{state:}       App state.
  \item{react_state:} The \code{react_state} components.
}
}
\description{
Populates the supplied session variable with information from
list of sources.
}
