% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{datasets.read_table}
\alias{datasets.read_table}
\title{Reads a tabular Foundry dataset as data.frame or an Apache Arrow Table.}
\usage{
datasets.read_table(
  alias,
  columns = NULL,
  row_limit = NULL,
  format = "data.frame"
)
}
\arguments{
\item{alias}{The alias representing the Dataset. The Dataset must be tabular, i.e. have a schema.}

\item{columns}{The subset of columns to retrieve.}

\item{row_limit}{The maximum number of rows to retrieve.}

\item{format}{The output format, can be 'arrow' or 'data.frame'.}
}
\value{
A data.table or an Arrow Table
}
\description{
Reads a tabular Foundry dataset as data.frame or an Apache Arrow Table.
}
\section{Column types}{

Note that types may not match exactly the Foundry column types.
See https://arrow.apache.org/docs/r/articles/arrow.html for details on type conversions
from an arrow Table to a data.frame.
}

\examples{
\dontrun{
# Download a subset of a tabular Dataset
df <- datasets.read_table("my_input", columns = c("columnA", "columnB"), row_limit = 1000)
}

}
