% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpaccess.R
\name{Fpsn_w}
\alias{Fpsn_w}
\title{Fpsn_w}
\usage{
Fpsn_w(x, w, Kmax, mini = min(x), maxi = max(x))
}
\arguments{
\item{x}{a numerical vector to segment}

\item{w}{a numerical vector of weights (values should be larger than 0).}

\item{Kmax}{max number of segments (segmentations in 1 to Kmax segments are recovered).}

\item{mini}{minimum mean segment value to consider in the optimisation}

\item{maxi}{maximum mean segment value to consider in the optimisation}
}
\value{
return a list with a matrix t.est containing the change-points of the segmentations in 1 to Kmax changes and, the costs J.est in 1 to Kmax changes.
}
\description{
Function to run the weighted pDPA algorithm (Rigaill 2010 and 2015). It uses functional pruning and segment neighborhood. It optimizes the weighted L2-loss (\eqn{w_i (x_i - \mu)2}) for 1 to Kmax changes.
}
\examples{
x <- c(rnorm(100), rnorm(10^3)+2, rnorm(1000)+1)
res <- Fpsn_w(x=x, w=rep(1, length(x)), K=100)
select.res <- select_Fpsn(res, method="givenVariance")
smt <- getSMT(res, select.res)
}
