% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{mghheader.ras2vox}
\alias{mghheader.ras2vox}
\title{Compute ras2vox matrix from basic MGH header fields.}
\usage{
mghheader.ras2vox(header)
}
\arguments{
\item{header}{the MGH header}
}
\value{
4x4 numerical matrix, the transformation matrix
}
\description{
This is also known as the 'scanner' or 'native' ras2vox. It is the inverse of the respective vox2ras, see \code{\link[freesurferformats]{mghheader.vox2ras}}.
}
\examples{
    brain_image = system.file("extdata", "brain.mgz",
                               package = "freesurferformats",
                               mustWork = TRUE);
    vdh = read.fs.mgh(brain_image, with_header = TRUE);
    mghheader.ras2vox(vdh$header);

}
\seealso{
Other header coordinate space: 
\code{\link{mghheader.is.ras.valid}()},
\code{\link{mghheader.ras2vox.tkreg}()},
\code{\link{mghheader.scanner2tkreg}()},
\code{\link{mghheader.tkreg2scanner}()},
\code{\link{mghheader.vox2ras.tkreg}()},
\code{\link{mghheader.vox2ras}()}
}
\concept{header coordinate space}
