% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spilloversRolling.R
\name{spilloverRollingBK12}
\alias{spilloverRollingBK12}
\title{Computing rolling frequency spillover from a generalized fevd as defined by Barunik, Krehlik (2018)}
\usage{
spilloverRollingBK12(
  data,
  n.ahead = 100,
  no.corr,
  partition,
  func_est,
  params_est,
  window,
  cluster = NULL
)
}
\arguments{
\item{data}{variable containing the dataset}

\item{n.ahead}{how many periods ahead should the FEVD be computed, generally this number
should be high enough so that it won't change with additional period}

\item{no.corr}{boolean parameter whether the off-diagonal in the covariance matrix should be
set to zero}

\item{partition}{defines the frequency partitions to which the spillover should be decomposed}

\item{func_est}{a name of the function to estimate with, for example "var" for VAR from vars package}

\item{params_est}{a list of the parameters to pass to the function besides the data that are passed as a first element.}

\item{window}{length of the window to be rolled}

\item{cluster}{either NULL for no parallel processing or the variable containing the cluster.}
}
\description{
This function computes the rolling spillover using the standard VAR estimate.
We implement the parallel version for faster processing. The window is of fixed window
and is rolled over the data. Interpretation of the other parameters is the same as in the
standard computation of spillover.
}
\author{
Tomas Krehlik <tomas.krehlik@gmail.com>
}
