% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_safe}
\alias{call_safe}
\title{Call a Function Given an External Dependency on Non-Windows Systems}
\usage{
call_safe(f, dependency, fallback = "Fallback", ...)
}
\arguments{
\item{f}{The function passed to \code{\link{do.call}}.}

\item{dependency}{The external dependency, see \emph{Examples}.}

\item{fallback}{See \emph{Description}.}

\item{...}{arguments passed to \code{\link{do.call}}.}
}
\value{
The return value of \code{f} or \code{fallback}.
}
\description{
Just a specialized version of \code{\link{call_conditionally}}.
}
\examples{
call_safe(whoami::email_address, dependency = "whoami",
          args = list(fallback = "foobar@nowhere.com"),
          fallback = "nobar@nowhere.com")
call_safe(whoami::email_address, dependency = "this_is_not_installed",
          args = list(fallback = "foobar@nowhere.com"),
          fallback = "nobar@nowhere.com")
}
\seealso{
Other call functions.: 
\code{\link{call_conditionally}()}
}
\concept{call functions.}
