% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTR.R
\name{DTR}
\alias{DTR}
\title{Calculation of the diurnal temperature range (DTR)}
\usage{
DTR(climdata, init_d, end_d)
}
\arguments{
\item{climdata}{a dataframe with daily maximum and minimum temperatures.
Must contain the columns Year, Month, Day, Tmax, Tmin.}

\item{init_d}{the initial date (as day of the year) of the evaluation period}

\item{end_d}{the end date (as day of the year) of the evaluation period}
}
\value{
dataframe with the value of DTR for each year in the series. 
It contains the columns Year, First_d, Last_d, DTR
}
\description{
This function calculates the mean diurnal temperature range (DTR) for
a custom period. Mean DTR is obtained by subtracting the daily minimum
temperature (Tmin) from daily maximum temperature (Tmax) and then
averaged for the period defined by the user, provided as the initial
(init) and end (end) date expressed as days of the year. The function
requires the initial and end dates to be in the same year.
}
\examples{

# Select the appropiate columns from the Tudela_DW example dataset,
# and estimate the mean DTR for July on each year in the dataset.
library(tidyverse)
Weather <- Tudela_DW \%>\%
   select(Year, Month, Day, Tmax, Tmin)
DTR_July <- DTR(Weather, 182, 212)

}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
