% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsi_functions.R
\name{fsi_add_fsa}
\alias{fsi_add_fsa}
\title{Adding an antecedent to an FSI model}
\usage{
fsi_add_fsa(fsi, lvar, tbl)
}
\arguments{
\item{fsi}{The FSI model instantiated with the \code{fsi_create} function.}

\item{lvar}{A character value that represents a linguistic variable of the antecedent.}

\item{tbl}{A tibble with spatial plateau objects annotated with linguistic values of the linguistic variable specified by the above \code{lvar} parameter.}
}
\value{
An FSI model populated with a fuzzy spatial antecedent.
}
\description{
This function adds a fuzzy spatial antecedent to a fuzzy spatial inference (FSI) model.
A fuzzy spatial antecedent corresponds to a layer of fuzzy spatial objects that describe the different characteristics of the problem.
The antecedent has a linguistic variable and its fuzzy spatial objects have linguistic values so that they are used in the IF part of fuzzy rules.
}
\details{
The fuzzy spatial antecedent added by the \code{fsi_add_fsa} function is composed of a linguistic variable and its corresponding \code{pgeometry} objects annotated by linguistic values.
The format of the \code{tbl} parameter is the same as the output of the function \code{spa_creator}, allowing the user to directly provides plateau region objects as input when designing FSI models.
}
\examples{

library(FuzzyR)
library(tibble)

# Create spatial plateau objects for the linguistic variable accomodation_price
lvals_accom_price <- c("cut-rate", "affordable", "expensive")
cut_rate_mf <- genmf("trapmf", c(0, 0, 10, 48))
affordable_mf <- genmf("trapmf", c(10, 48, 80, 115))
expensive_mf <- genmf("trapmf", c(80, 115, 10000, 10000))

# Example of dataset
accom_price <- tibble(
                      `longitude` = c(-74.0, -74.0, -74.0), 
                      `latitude` = c(40.8, 40.7, 40.7),
                      `price` = c(150, 76, 60)
)
 
accom_price_layer <- spa_creator(accom_price, classes = lvals_accom_price, 
                         mfs = c(cut_rate_mf, affordable_mf, expensive_mf))
                         
# Create the fsi_model:
fsi <- fsi_create("To visit or not to visit, that is the question", 
                  default_conseq = genmf("trimf", c(10, 30, 60)))

# Add the fuzzy spatial antecedent to the fsi_model:
fsi <- fsi_add_fsa(fsi, "accommodation price", accom_price_layer)

}
