% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_fude.R
\name{extract_fude}
\alias{extract_fude}
\title{Extract specified Fude Polygon data}
\usage{
extract_fude(data, year = NULL, city = NULL, list = TRUE)
}
\arguments{
\item{data}{List of \code{\link[sf:sf]{sf::sf()}} objects.}

\item{year}{Year to be extracted. If both \code{year} and \code{city} are not
specified, all objects for the most recent year are extracted.}

\item{city}{Local government name (or code) to be extracted.}

\item{list}{Logical. If \code{FALSE}, the object to be extracted is no longer a list.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} object(s).
}
\description{
\code{extract_fude()} extracts the specified data from the list returned by
\code{\link[=read_fude]{read_fude()}}.
}
\examples{
path <- system.file("extdata", "castle.zip", package = "fude")
d <- read_fude(path)
d2 <- extract_fude(d, year = 2022, city = '\u677e\u5c71\u5e02')
d |> extract_fude(year = 2022)
}
\seealso{
\code{\link[=read_fude]{read_fude()}}.
}
