% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{fboot_read}
\alias{fboot_read}
\title{Read the robustness of a functional clustering
 evaluated by bootstrapping from 1 to (all-1) observations}
\usage{
fboot_read(filename,
           opt.var = c("assemblages", "performances"))
}
\arguments{
\item{filename}{a string, used as radical for naming the file
\code{"filename.components.csv"}, \code{"filemane.assemblages.csv"}
or \code{"filemane.performances.csv"}
according to the dimensions of matrices.}

\item{opt.var}{a string, that indicates the variable to test.
The option can be \code{"assemblages"} or \code{"performances"}.}
}
\value{
a list of list of matrices,
 identical to this resulting from the function \code{fboot}.
}
\description{
Read a file of results obtained by
a test of significance of functional clustering.
}
\details{
The function \code{fboot} ,
  generate a list of lists, each one containing a matrix by clustering index
  ("Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
  "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
  "Sokal_Sneath1" and "Sokal_Sneath2" index).
  Only their dimensions change according the used functions.
  Consequently, a same function is used for recording and reading
  the results of both the test-functions.
}
\examples{

# save "rtest" in the file "myRecord.*".

filename <- tempfile(pattern = "myRecord", tmpdir = tempdir())

fboot_write(fres = CedarCreek.2004.2006.res,
            lboot = CedarCreek.2004.2006.boot.performances,
            filename = filename,
            opt.var  = "performances")

lboot <- fboot_read(filename = filename, opt.var = "performances")

all.equal(lboot, CedarCreek.2004.2006.boot.performances)


}
