% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderFactors.R
\name{orderFactors}
\alias{orderFactors}
\title{Order factor-loadings matrix by the sum of squared factor loadings}
\usage{
orderFactors(Lambda, PhiMat, salient = 0.29, reflect = TRUE)
}
\arguments{
\item{Lambda}{(Matrix) Factor loadings matrix to be reordered.}

\item{PhiMat}{(Matrix, NULL) Factor correlation matrix to be reordered.}

\item{salient}{(Numeric) Indicators with loadings < \code{salient} will be 
suppressed when computing the factor sum of squares values. Defaults to 
salient = .29.}

\item{reflect}{(Logical) If true, negatively-keyed factors will be reflected.
Defaults to reflect = TRUE.}
}
\value{
Returns the sorted factor loading and factor correlation matrices. 
\itemize{
  \item \strong{Lambda}: (Matrix) The sorted factor loadings matrix.
  \item \strong{Phi}: (Matrix) The sorted factor correlation matrix.
}
}
\description{
Order the columns of a factor loadings matrix in descending order based on 
the sum of squared factor loadings.
}
\examples{
\dontrun{
Loadings <- 
  matrix(c(.49, .41, .00, .00,
           .73, .45, .00, .00,
           .47, .53, .00, .00,
           .54, .00, .66, .00,
           .60, .00, .38, .00,
           .55, .00, .66, .00,
           .39, .00, .00, .68,
           .71, .00, .00, .56,
           .63, .00, .00, .55), 
         nrow = 9, ncol = 4, byrow = TRUE)
         
fungible::orderFactors(Lambda = Loadings,
                        PhiMat = NULL)$Lambda
}

}
\seealso{
Other Factor Analysis Routines: 
\code{\link{BiFAD}()},
\code{\link{Box26}},
\code{\link{GenerateBoxData}()},
\code{\link{Ledermann}()},
\code{\link{SLi}()},
\code{\link{SchmidLeiman}()},
\code{\link{faAlign}()},
\code{\link{faEKC}()},
\code{\link{faIB}()},
\code{\link{faLocalMin}()},
\code{\link{faMB}()},
\code{\link{faMain}()},
\code{\link{faScores}()},
\code{\link{faSort}()},
\code{\link{faStandardize}()},
\code{\link{faX}()},
\code{\link{fals}()},
\code{\link{fapa}()},
\code{\link{fareg}()},
\code{\link{print.faMB}()},
\code{\link{print.faMain}()},
\code{\link{promaxQ}()},
\code{\link{summary.faMB}()},
\code{\link{summary.faMain}()}
}
\concept{Factor Analysis Routines}
