% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/washer.R
\name{washer}
\alias{washer}
\title{Wash Your Data}
\usage{
washer(x, ..., value = NA)
}
\arguments{
\item{x}{the variable to have values adjusted}

\item{...}{the values in the variable that are to be replaced by either NA's or the value set by the user. Can be a function (or multiple functions) to specify values to change (e.g., is.nan(), is.na()).}

\item{value}{(optional) if specified, the values in ... will be replaced by this value (must be a single value)}
}
\value{
A table with the number of observations, means/frequencies and standard deviations/percentages is returned. The object is a \code{table1} class object with a print method. Can be printed in \code{LaTex} form.
}
\description{
Washes the data by replacing values with either NA's or other values set by the user. 
Useful for replacing values such as 777's or 999's that represent missing values in survey research.
Can also perform many useful functions on factors (e.g., removing a level, replacing a level, etc.)
}
\examples{
x = c(1:20, NA, NaN)
washer(x, 9, 10)
washer(x, 9, 10, value=0)
washer(x, 1:10)
washer(x, is.na, is.nan, value=0)
washer(x, is.na, is.nan, 1:3, value=0)

}

