% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiprocess.R
\name{multiprocess}
\alias{multiprocess}
\title{Create a multiprocess future whose value will be resolved asynchroneously using multicore or a multisession evaluation}
\usage{
multiprocess(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, maxCores = availableCores(), ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done and from which globals are obtained.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{If TRUE, global objects are validated at the point
in time when the future is created (always before it is resolved),
that is, they identified and located.  If some globals fail to be
located, an informative error is generated.}

\item{maxCores}{The maximum number of multiprocess futures that
can be active at the same time before blocking.}

\item{\dots}{Not used.}
}
\value{
A \link{MultiprocessFuture} implemented as either a
\link{MulticoreFuture} or a \link{MultisessionFuture}.
}
\description{
A multiprocess future is a future that uses \link{multicore} evaluation
if supported, otherwise it uses \link{multisession} evaluation.
Regardless, its \emph{value is computed and resolved in
parallel in another process}.
}
\examples{
## Multiprocess futures gives an error on R CMD check on
## Windows (but not Linux or OS X) for unknown reasons.
## The same code works in package tests.
\donttest{

## Use multiprocess futures
plan(multiprocess)

## A global variable
a <- 0

## Create multicore future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multiprocess future is evaluated in a separate R process.
## Changing the value of a global variable will not affect
## the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

}
}
\seealso{
Internally \code{\link{multicore}()} and \code{\link{multisession}()}
are used.
}

