% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzylm.R
\name{fuzzylm}
\alias{fuzzylm}
\title{Fuzzy Linear Regression}
\usage{
fuzzylm(
  formula,
  data,
  method = "plrls",
  fuzzy.left.x = NULL,
  fuzzy.right.x = NULL,
  fuzzy.left.y = NULL,
  fuzzy.right.y = NULL,
  silent = FALSE,
  ...
)
}
\arguments{
\item{formula}{a model formula.}

\item{data}{a data.frame, containing the variables used in formula.}

\item{method}{method for fitting of the fuzzy linear model.}

\item{fuzzy.left.x}{character string vector specifying column name(s) with the left 
spread of the fuzzy independent variable(s).}

\item{fuzzy.right.x}{character string vector specifying column name(s) with the right 
spread of the fuzzy independent variable(s).}

\item{fuzzy.left.y}{character string vector specifying column name(s) with the left 
spread of the fuzzy dependent variable.}

\item{fuzzy.right.y}{character string vector specifying column name(s) with the right 
spread of the fuzzy dependent variable.}

\item{silent}{logical whether warnings should be printed.}

\item{...}{additional parameters used by specific methods, check functions 
\code{\link{moflr}}, \code{\link{oplr}}, \code{\link{plr}}, and \code{\link{plrls}}
for full list of optional method-specific arguments.}
}
\value{
Returns a \code{fuzzylm} object that includes the model coefficients, limits
  for data predictions from the model and the input data.
}
\description{
A wrapper function that calculates fuzzy regression coeficients using a chosen method.
}
\details{
The implemented methods include \code{\link{plrls}} (Lee and Tanaka 1999) and
  \code{\link{bfrl}} (Skrabanek et al. 2021) for fitting the fuzzy linear
  regression from the crisp input data, and \code{\link{fls}} 
  (Diamond 1988), \code{\link{oplr}} (Hung and Yang 2006), \code{\link{moflr}}
  (Nasrabadi et al. 2005) and \code{\link{plr}} (Tanaka et al. 1989) methods for
  triangular fuzzy numbers.
}
\examples{
data(fuzzydat)
fuzzylm(y ~ x, data = fuzzydat$lee, method = "plrls")
\dontrun{
# returns an error due to the incorrect number of spreads
fuzzylm(y ~ x, data = fuzzydat$dia, method = "fls", fuzzy.left.y = "yl")
}
# use the same column name for the left and right spread, when the method requests 
# non-symmetric fuzzy numbers, but the data specify symmetric fuzzy numbers 
fuzzylm(y ~ x, data = fuzzydat$dia, method = "fls", fuzzy.left.y = "yl", fuzzy.right.y = "yl")
}
\references{
Diamond, P. (1988) Fuzzy least squares. \emph{Information Sciences}
  46(3): 141-157.

  Hung, W.-L. and Yang, M.-S. (2006) An omission approach for detecting 
  outliers in fuzzy regression models. \emph{Fuzzy Sets and Systems} 157: 3109-3122.

  Lee, H. and Tanaka, H. (1999) Fuzzy approximations with non-symmetric fuzzy
  parameters in fuzzy regression analysis. \emph{Journal of the Operations Research
  Society Japan} 42: 98-112.

  Nasrabadi, M. M., Nasrabadi, E. and Nasrabady, A. R. (2005) Fuzzy linear 
  regression analysis: a multi-objective programming approach. \emph{Applied Mathematics
  and Computation} 163: 245-251.

  Skrabanek, P., Marek, J. and Pozdilkova, A. (2021) Boscovich Fuzzy Regression 
  Line. \emph{Mathematics} 9: 685.

  Tanaka, H., Hayashi, I. and Watada, J. (1989) Possibilistic linear 
  regression analysis for fuzzy data. \emph{European Journal of Operational 
  Research} 40: 389-396.

  Zeng, W., Feng, Q. and Li, J. (2017) Fuzzy least absolute linear regression. 
  \emph{Applied Soft Computing} 52: 1009-1019.
}
\seealso{
\code{\link[=plot.fuzzylm]{plot}}, \code{\link[=predict.fuzzylm]{predict}}, 
  \code{\link[=summary.fuzzylm]{summary}}
}
