% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pval}
\alias{pval}
\title{\code{pval} is a S3 method to collect pvalues for objects
of type \code{boottest} and \code{mboottest}}
\usage{
pval(object, ...)
}
\arguments{
\item{object}{An object of type lm, fixest, felm or ivreg}

\item{...}{other arguments}
}
\value{
A scalar with the bootstrapped p-value.
}
\description{
\code{pval} is a S3 method to collect pvalues for objects
of type \code{boottest} and \code{mboottest}
}
\examples{
requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
pval(boot)
}
