% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{nobs.boottest}
\alias{nobs.boottest}
\title{S3 method to obtain the effective number of observation used in \code{boottest()}}
\usage{
\method{nobs}{boottest}(object, ...)
}
\arguments{
\item{object}{object of type boottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A scalar containing the effective number of observations
used in \code{boottest()}
}
\description{
S3 method to obtain the effective number of observation used in \code{boottest()}
}
\examples{
requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
nobs(boot)
}
