% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.boottest}
\alias{print.boottest}
\title{S3 method to print key information for objects of type \code{bboottest}}
\usage{
\method{print}{boottest}(x, ..., digits = 4)
}
\arguments{
\item{x}{object of type boottest}

\item{...}{Further arguments passed to or from other methods.}

\item{digits}{Number of rounding digits}
}
\value{
A scalar containing the effective number of observations
used in \code{mboottest}
}
\description{
S3 method to print key information for objects of type \code{bboottest}
}
\examples{
#' requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
  proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
print(boot)

}
