% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pval.mboottest}
\alias{pval.mboottest}
\title{S3 method to obtain the wild cluster bootstrapped p-value of an object
of type mboottest}
\usage{
\method{pval}{mboottest}(object, ...)
}
\arguments{
\item{object}{object of type mboottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector containing the boundaries of the wild cluster
bootstrapped p-value
}
\description{
S3 method to obtain the wild cluster bootstrapped p-value of an object
of type mboottest
}
\examples{
\dontrun{
requireNamespace("clubSandwich")
R <- clubSandwich::constrain_zero(2:3, coef(lm_fit))
wboottest <-
  mboottest(
    object = lm_fit,
    clustid = "group_id1",
    B = 999,
    R = R
  )
pval(wboottest)
}

}
