% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{teststat.mboottest}
\alias{teststat.mboottest}
\title{S3 method to obtain the non-bootstrapped test statistic calculated
via \code{mboottest()}}
\usage{
\method{teststat}{mboottest}(object, ...)
}
\arguments{
\item{object}{An object of type 'mboottest'}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector containing the non-bootstrapped t-statistic calculated
in \code{mboottest()}
}
\description{
S3 method to obtain the non-bootstrapped test statistic calculated
via \code{mboottest()}
}
\examples{
\dontrun{
requireNamespace("clubSandwich")
R <- clubSandwich::constrain_zero(2:3, coef(lm_fit))
wboottest <-
  mboottest(
    object = lm_fit,
    clustid = "group_id1",
    B = 999,
    R = R
  )
teststat(wboottest)
}

}
