% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{rand.t.test.w}
\alias{rand.t.test.w}
\title{Random t-test}
\usage{
rand.t.test.w(cvoutput, n.perm = 999)
}
\arguments{
\item{cvoutput}{cross-validation output either from \code{\link{cv.w}} or
\code{\link{cv.pr.w}}}

\item{n.perm}{the number of permutation times to get the p value, which
assesses whether using the current number of components is significantly
different from using one less.}
}
\value{
a matrix of the statistics of the cross-validation results
}
\description{
Do a random t-test to the cross-validation results
}
\examples{
# Load modern pollen data
modern_pollen <- read.csv(system.file("extdata", 
                                      "Modern_Pollen_gdd_alpha_Tmin.csv", 
                                      package = "fxTWAPLS", 
                                      mustWork = TRUE))

# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "Abies")
taxaColMax <- which(colnames(modern_pollen) == "Zygophyllaceae")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Get the frequency of each climate variable fx
fx_Tmin <- fxTWAPLS::fx(modern_pollen$Tmin, bin = 0.02)
fx_gdd <- fxTWAPLS::fx(modern_pollen$gdd, bin = 20)
fx_alpha <- fxTWAPLS::fx(modern_pollen$alpha, bin = 0.002)

# MTCO
## fx
fit_Tmin <- fxTWAPLS::WAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
## LOOCV
test_mode <- TRUE # It should be set to FALSE before running
### without fx
cv_Tmin <- fxTWAPLS::cv.w(taxa,
                          modern_pollen$Tmin,
                          nPLS = 5,
                          fxTWAPLS::WAPLS.w,
                          fxTWAPLS::WAPLS.predict.w,
                          cpus = 2, # Remove the following line
                          test_mode = test_mode)
### with fx
cv_f_Tmin <- fxTWAPLS::cv.w(taxa,
                            modern_pollen$Tmin,
                            nPLS = 5,
                            fxTWAPLS::WAPLS.w,
                            fxTWAPLS::WAPLS.predict.w,
                            usefx = TRUE,
                            fx = fx_Tmin,
                            cpus = 2, # Remove the following line
                            test_mode = test_mode)
\donttest{
## Random t-test
rand_Tmin <- fxTWAPLS::rand.t.test.w(cv_Tmin, n.perm = 999)
rand_f_Tmin <- fxTWAPLS::rand.t.test.w(cv_f_Tmin, n.perm = 999)
}

}
\seealso{
\code{\link{cv.w}} and \code{\link{cv.pr.w}}
}
