/*
 * Decompiled with CFR 0.152.
 */
package junit;

import junit.MyTestCase;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RNumeric;
import org.af.jhlir.call.RVectorFactor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RDataFrame_Test
extends MyTestCase {
    protected RDataFrame rDf1;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getRServices().assign("rdf1", "data.frame(xx=1:3, c(1.5, 5, -4), zz=c(\"foo\", \"bar\", \"bla\"), yy=4:6)");
        this.rDf1 = this.getRServices().eval("rdf1").asRDataFrame();
    }

    @Test
    public void testAt() {
        Assert.assertEquals((long)this.rDf1.getRowCount(), (long)3L);
        Assert.assertEquals((long)this.rDf1.getColumnCount(), (long)4L);
        Object[] cns = this.rDf1.getColNames();
        Assert.assertEquals((Object)cns[0], (Object)"xx");
        Assert.assertEquals((Object)cns[2], (Object)"zz");
        Assert.assertEquals((Object)cns[3], (Object)"yy");
        cns = this.rDf1.getColNamesAsList().toArray();
        Assert.assertEquals((Object)cns[0], (Object)"xx");
        Assert.assertEquals((Object)cns[2], (Object)"zz");
        Assert.assertEquals((Object)cns[3], (Object)"yy");
        Assert.assertEquals((Object)this.rDf1.get(0, 0), (Object)1);
        Assert.assertEquals((Object)this.rDf1.get(1, 0), (Object)2);
        Assert.assertEquals((Object)this.rDf1.get(2, 0), (Object)3);
        Assert.assertEquals((Object)this.rDf1.get(0, 1), (Object)1.5);
        Assert.assertEquals((Object)this.rDf1.get(1, 1), (Object)5.0);
        Assert.assertEquals((Object)this.rDf1.get(2, 1), (Object)-4.0);
        Assert.assertEquals((Object)this.rDf1.get(0, 2), (Object)"foo");
        Assert.assertEquals((Object)this.rDf1.get(1, 2), (Object)"bar");
        Assert.assertEquals((Object)this.rDf1.get(2, 2), (Object)"bla");
        Assert.assertEquals((Object)this.rDf1.get(0, 3), (Object)4);
        Assert.assertEquals((Object)this.rDf1.get(1, 3), (Object)5);
        Assert.assertEquals((Object)this.rDf1.get(2, 3), (Object)6);
        RInteger ri = this.rDf1.getCol(0).asRInteger();
        Assert.assertEquals(ri.get(0), (Object)1);
        Assert.assertEquals(ri.get(1), (Object)2);
        Assert.assertEquals(ri.get(2), (Object)3);
        RNumeric rn = this.rDf1.getCol(1).asRNumeric();
        Assert.assertEquals(rn.get(0), (Object)1.5);
        Assert.assertEquals(rn.get(1), (Object)5.0);
        Assert.assertEquals(rn.get(2), (Object)-4.0);
        RVectorFactor zz = this.rDf1.getCol(2);
        Assert.assertEquals((long)zz.getLength(), (long)3L);
        zz = this.rDf1.getCol("zz");
        Assert.assertEquals((long)zz.getLength(), (long)3L);
        String[] levels = this.rDf1.getCol("zz").asRFactor().getLevels();
        Assert.assertEquals((Object)levels[0], (Object)"bar");
        Assert.assertEquals((Object)levels[0], (Object)"bla");
        Assert.assertEquals((Object)levels[2], (Object)"foo");
    }
}

