/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.DataFramePanel;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.dialogs.MatrixCreationDialog;
import org.af.gMCP.gui.dialogs.PowerParameterPanel;
import org.af.gMCP.gui.dialogs.TextFileViewer;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;

public class PowerDialogParameterUncertainty
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    CreateGraphGUI parent;
    Vector<Node> nodes;
    List<JTextField> jtl;
    List<JTextField> jtlMu;
    List<JTextField> jtlN;
    List<JTextField> jtlSigma;
    JTextArea jta = new JTextArea();
    DataFramePanel dfp;
    JTextField jtUserDefined = new JTextField();
    DefaultListModel listModel;
    JList listUserDefined;
    JTabbedPane tPanel = new JTabbedPane();
    GridBagConstraints c = new GridBagConstraints();
    List<JButton> buttons = new Vector<JButton>();
    List<JButton> buttons2 = new Vector<JButton>();
    JButton switchNCP = new JButton("Enter \u00b5, \u03c3 and n instead of ncp");
    boolean ncp = true;
    JPanel singleNCP = new JPanel();
    JPanel singleMuSigmaN = new JPanel();
    JPanel panel = new JPanel();
    JButton createCV = new JButton("Advanced Matrix Creation");
    JButton loadCV = new JButton("Load Matrix from R");
    JButton ok2 = new JButton("Ok");
    PowerParameterPanel pPanelMeans;
    PowerParameterPanel pPanelSigmas;
    PowerParameterPanel pPanelN;
    JButton addAnother = new JButton("Add another power function");

    public PowerDialogParameterUncertainty(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.nodes = parent.getGraphView().getNL().getNodes();
        if (parent.getPView().jrbRCorrelation.isSelected()) {
            parent.getPView().jcbCorObject.getSelectedItem();
        }
        parent.getPView().getParameters();
        this.c.fill = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.ipadx = 10;
        this.c.ipady = 10;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.tPanel.addTab("Single NCP Setting", this.getSingleSettingPanel());
        this.tPanel.addTab("Multiple NCP Settings", this.getMultiSettingPanel());
        this.tPanel.addTab("Covariance Matrix", this.getCVPanel());
        this.tPanel.addTab("User defined power function", this.getUserDefinedFunctions());
        this.getContentPane().add(this.tPanel);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public JPanel getSingleSettingPanel() {
        JPanel mPanel = new JPanel();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String cols2 = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.nodes) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.singleNCP.setLayout((LayoutManager)layout);
        layout = new FormLayout(cols2, rows);
        this.singleMuSigmaN.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.singleMuSigmaN.add((Component)new JLabel("\u00b5"), cc.xy(4, row));
        this.singleMuSigmaN.add((Component)new JLabel("\u03c3"), cc.xy(6, row));
        this.singleMuSigmaN.add((Component)new JLabel("n"), cc.xy(8, row));
        this.jtl = new Vector<JTextField>();
        this.jtlMu = new Vector<JTextField>();
        this.jtlSigma = new Vector<JTextField>();
        this.jtlN = new Vector<JTextField>();
        for (Node n : this.nodes) {
            JTextField jt = new JTextField("0");
            this.singleNCP.add((Component)new JLabel("Noncentrality parameter for '" + n.getName() + "':"), cc.xy(2, row));
            this.singleNCP.add((Component)jt, cc.xy(4, row));
            this.jtl.add(jt);
            this.singleMuSigmaN.add((Component)new JLabel("Parameters for '" + n.getName() + "':"), cc.xy(2, row += 2));
            jt = new JTextField("0");
            this.singleMuSigmaN.add((Component)jt, cc.xy(4, row));
            this.jtlMu.add(jt);
            jt = new JTextField("1");
            this.singleMuSigmaN.add((Component)jt, cc.xy(6, row));
            this.jtlSigma.add(jt);
            jt = new JTextField("10");
            this.singleMuSigmaN.add((Component)jt, cc.xy(8, row));
            this.jtlN.add(jt);
        }
        cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        cc = new CellConstraints();
        row = 2;
        mPanel.add((Component)new JLabel("Noncentrality parameter of multivariate normal distribution"), cc.xy(2, row));
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)this.singleNCP, this.c);
        mPanel.add((Component)new JScrollPane(this.panel), cc.xy(2, row += 2));
        mPanel.add((Component)this.switchNCP, cc.xy(2, row += 2));
        this.switchNCP.addActionListener(this);
        mPanel.add((Component)this.ok, cc.xy(4, row));
        this.ok.addActionListener(this);
        return mPanel;
    }

    public JPanel getCVPanel() {
        JPanel mPanel = new JPanel();
        RDataFrameRef df = new RDataFrameRef();
        for (Node n : this.parent.getGraphView().getNL().getNodes()) {
            df.addRowCol(n.getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new DataFramePanel(df);
        this.dfp.getTable().getModel().diagEditable = true;
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.dfp.getTable().getModel().setCheckRowSum(false);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        cc = new CellConstraints();
        mPanel.add((Component)new JLabel("Covariance matrix"), cc.xyw(2, row, 3));
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)this.singleNCP, this.c);
        mPanel.add((Component)new JScrollPane(this.dfp), cc.xyw(2, row += 2, 3));
        mPanel.add((Component)this.loadCV, cc.xy(2, row += 2));
        this.loadCV.addActionListener(this);
        mPanel.add((Component)this.createCV, cc.xy(4, row));
        this.createCV.addActionListener(this);
        return mPanel;
    }

    public JPanel getMultiSettingPanel() {
        JPanel mPanel = new JPanel();
        JTabbedPane parameters = new JTabbedPane();
        this.pPanelMeans = new PowerParameterPanel("mean", 0.0, this.nodes, this.parent);
        this.pPanelSigmas = new PowerParameterPanel("sd", 1.0, this.nodes, this.parent);
        this.pPanelN = new PowerParameterPanel("sample size", 10.0, this.nodes, this.parent);
        parameters.addTab("Mean \u00b5", this.pPanelMeans);
        parameters.addTab("Standard deviation \u03c3", this.pPanelSigmas);
        parameters.addTab("Sample size n", this.pPanelN);
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        mPanel.add((Component)parameters, cc.xy(2, row));
        mPanel.add((Component)this.ok2, cc.xy(4, row += 2));
        this.ok2.addActionListener(this);
        return mPanel;
    }

    public JPanel getUserDefinedFunctions() {
        JPanel mPanel = new JPanel();
        JButton b = new JButton("(");
        b.setActionCommand("(");
        this.buttons.add(b);
        b = new JButton(")");
        b.setActionCommand(")");
        this.buttons.add(b);
        b = new JButton("AND");
        b.setActionCommand("&&");
        this.buttons.add(b);
        b = new JButton("OR");
        b.setActionCommand("||");
        this.buttons.add(b);
        b = new JButton("NOT");
        b.setActionCommand("!");
        this.buttons.add(b);
        for (int i = 0; i < this.nodes.size(); ++i) {
            b = new JButton(this.nodes.get(i).getName());
            b.setActionCommand("x[" + (i + 1) + "]");
            this.buttons2.add(b);
        }
        JPanel hypPanel = new JPanel();
        for (JButton button : this.buttons2) {
            button.addActionListener(this);
            hypPanel.add(button);
        }
        JPanel opPanel = new JPanel();
        for (JButton button : this.buttons) {
            button.addActionListener(this);
            opPanel.add(button);
        }
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.setText("In the text field above you can enter an user defined power function.\nUse the R syntax and \"x[i]\" to specify the proposition that hypothesis i\ncould be rejected. Alternatively use the buttons below.\nExample:  (x[1] && x[2]) || x[4]\nThis calculates the probability that the first and second\nor (not exclusive) the fourth null hypothesis can be rejected.\nNote that you can use all R commands, for example also\nany(x) to see whether any hypotheses was rejected or\nall(x[1:4]) to see whether all of the first four hypotheses were rejected.\nHit return to add another user defined power functions.");
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtUserDefined.addActionListener(this);
        mPanel.add((Component)this.jtUserDefined, cc.xy(2, row));
        this.addAnother.addActionListener(this);
        mPanel.add((Component)this.addAnother, cc.xy(4, row));
        this.listModel = new DefaultListModel();
        this.listUserDefined = new JList(this.listModel);
        mPanel.add((Component)new JScrollPane(this.jta), cc.xy(2, row += 2));
        mPanel.add((Component)new JScrollPane(this.listUserDefined), cc.xy(4, row));
        mPanel.add((Component)new JScrollPane(hypPanel), cc.xyw(2, row += 2, 3));
        mPanel.add((Component)new JScrollPane(opPanel), cc.xyw(2, row += 2, 3));
        row += 2;
        return mPanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.createCV) {
            MatrixCreationDialog mcd = new MatrixCreationDialog(this.parent, this.dfp.getTable().getRMatrix());
            this.dfp.getTable().getModel().copy(mcd.dfp.getTable().getModel());
            return;
        }
        if (e.getSource() == this.loadCV) {
            VariableNameDialog vnd = new VariableNameDialog(this.parent);
            double[] result = RControl.getR().eval("as.numeric(" + vnd.getName() + ")").asRNumeric().getData();
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.dfp.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                }
            }
            return;
        }
        if (this.switchNCP == e.getSource()) {
            this.panel.removeAll();
            if (this.ncp) {
                this.switchNCP.setText("Enter ncp instead of \u00b5, \u03c3 and n");
                this.ncp = false;
                this.panel.add((Component)this.singleMuSigmaN, this.c);
            } else {
                this.switchNCP.setText("Enter \u00b5, \u03c3 and n instead of ncp");
                this.ncp = true;
                this.panel.add((Component)this.singleNCP, this.c);
            }
            this.panel.revalidate();
            this.panel.repaint();
            return;
        }
        if (this.buttons.contains(e.getSource()) || this.buttons2.contains(e.getSource())) {
            this.jtUserDefined.setText(this.jtUserDefined.getText() + " " + ((JButton)e.getSource()).getActionCommand());
            return;
        }
        if (this.jtUserDefined.getText().length() > 0) {
            this.listModel.insertElementAt(this.jtUserDefined.getText(), 0);
            this.jtUserDefined.setText("");
        }
        if (e.getSource() == this.jtUserDefined || e.getSource() == this.addAnother) {
            return;
        }
        String weights = this.parent.getGraphView().getNL().getGraphName() + "@weights";
        double alpha = this.parent.getPView().getTotalAlpha();
        String G = this.parent.getGraphView().getNL().getGraphName() + "@m";
        double[] means = new double[this.nodes.size()];
        String settings = null;
        String userDefinedF = this.getUserDefined();
        RControl.getR().eval(this.parent.getGraphView().getNL().getGraphName() + "<-gMCP:::parse2numeric(" + this.parent.getGraphView().getNL().getGraphName() + ")");
        if (e.getSource() == this.ok) {
            for (int i = 0; i < means.length; ++i) {
                means[i] = this.ncp ? Double.parseDouble(this.jtl.get(i).getText()) : Double.parseDouble(this.jtlMu.get(i).getText()) * Math.sqrt(Double.parseDouble(this.jtlN.get(i).getText())) / Double.parseDouble(this.jtlSigma.get(i).getText());
            }
            String mean = RControl.getRString(means);
            settings = ", mean=" + mean;
            RControl.getR().eval(".powerResult <- calcPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + settings + "," + "sigma = " + this.dfp.getTable().getModel().getDataFrame().getRMatrix() + userDefinedF + ", nSim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ")");
            double[] localPower = RControl.getR().eval(".powerResult$LocalPower").asRNumeric().getData();
            double expRejections = RControl.getR().eval(".powerResult$ExpRejections").asRNumeric().getData()[0];
            double powAtlst1 = RControl.getR().eval(".powerResult$PowAtlst1").asRNumeric().getData()[0];
            double rejectAll = RControl.getR().eval(".powerResult$RejectAll").asRNumeric().getData()[0];
            Double[] userDefined = new Double[this.listModel.getSize()];
            String[] functions = new String[this.listModel.getSize()];
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                functions[i] = this.listModel.get(i).toString();
                userDefined[i] = RControl.getR().eval(".powerResult$userDefined" + i).asRNumeric().getData()[0];
            }
            this.parent.getGraphView().getNL().setPower(localPower, expRejections, powAtlst1, rejectAll, userDefined, functions);
        } else {
            settings = ", muL = " + this.pPanelMeans.getRList() + ", sigmaL = " + this.pPanelSigmas.getRList() + ", nL = " + this.pPanelN.getRList();
            String result = RControl.getR().eval("gMCP:::calcMultiPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + settings + "," + "sigma = " + this.dfp.getTable().getModel().getDataFrame().getRMatrix() + userDefinedF + ", nSim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ")").asRChar().getData()[0];
            new TextFileViewer((JFrame)this.parent, "Power results", result, true);
        }
        this.dispose();
    }

    private String getUserDefined() {
        if (this.listModel.getSize() == 0) {
            return "";
        }
        String s = ", f=list(";
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            s = s + "userDefined" + i + "=function(x) {" + this.listModel.get(i) + "}";
            if (i == this.listModel.getSize() - 1) continue;
            s = s + ",";
        }
        return s + ")";
    }
}

