% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.extended.R
\name{bonferroni.trimmed.simes.test}
\alias{bonferroni.trimmed.simes.test}
\title{Trimmed Simes test for intersections of two hypotheses and otherwise weighted Bonferroni-test}
\usage{
bonferroni.trimmed.simes.test(pvalues, weights, alpha = 0.05,
  adjPValues = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{pvalues}{A numeric vector specifying the p-values.}

\item{weights}{A numeric vector of weights.}

\item{alpha}{A numeric specifying the maximal allowed type one error rate. If \code{adjPValues==TRUE} (default) the parameter \code{alpha} is not used.}

\item{adjPValues}{Logical scalar. If \code{TRUE} (the default) an adjusted p-value for the weighted test is returned.
Otherwise if \code{adjPValues==FALSE} a logical value is returned whether the null hypothesis can be rejected.}

\item{verbose}{Logical scalar. If \code{TRUE} verbose output is generated.}

\item{...}{Further arguments possibly passed by \code{gMCP} which will be used by other test procedures but not this one.}
}
\description{
Trimmed Simes test for intersections of two hypotheses and otherwise weighted Bonferroni-test
}
\examples{

bonferroni.trimmed.simes.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0))
bonferroni.trimmed.simes.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0), adjPValues=FALSE)

}
\references{
Brannath, W., Bretz, F., Maurer, W., & Sarkar, S. (2009). 
Trimmed Weighted Simes Test for Two One-Sided Hypotheses With Arbitrarily Correlated Test Statistics. 
Biometrical Journal, 51(6), 885-898.
}

