% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.extended.R
\name{simes.on.subsets.test}
\alias{simes.on.subsets.test}
\title{Simes on subsets, otherwise Bonferroni}
\usage{
simes.on.subsets.test(pvalues, weights, alpha = 0.05, adjPValues = TRUE,
  verbose = FALSE, subsets, subset, ...)
}
\arguments{
\item{pvalues}{A numeric vector specifying the p-values.}

\item{weights}{A numeric vector of weights.}

\item{alpha}{A numeric specifying the maximal allowed type one error rate. If \code{adjPValues==TRUE} (default) the parameter \code{alpha} is not used.}

\item{adjPValues}{Logical scalar. If \code{TRUE} (the default) an adjusted p-value for the weighted test is returned.
Otherwise if \code{adjPValues==FALSE} a logical value is returned whether the null hypothesis can be rejected.}

\item{verbose}{Logical scalar. If \code{TRUE} verbose output is generated.}

\item{subsets}{A list of subsets given by numeric vectors containing the indices of the elementary hypotheses for which the weighted Simes test is applicable.}

\item{subset}{A numeric vector containing the numbers of the indices of the currently tested elementary hypotheses.}

\item{...}{Further arguments possibly passed by \code{gMCP} which will be used by other test procedures but not this one.}
}
\description{
Weighted Simes test introduced by Benjamini and Hochberg (1997)
}
\details{
As an additional argument a list of subsets must be provided, that states in which cases a Simes test is applicable (i.e. if all hypotheses to test belong to one of these subsets), e.g.
subsets <- list(c("H1", "H2", "H3"), c("H4", "H5", "H6"))
Trimmed Simes test for intersections of two hypotheses and otherwise weighted Bonferroni-test
}
\examples{

simes.on.subsets.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0))
simes.on.subsets.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0), adjPValues=FALSE)

graph <- BonferroniHolm(4)
pvalues <- c(0.01, 0.05, 0.03, 0.02)

gMCP.extended(graph=graph, pvalues=pvalues, test=simes.on.subsets.test, subsets=list(1:2, 3:4))

}

