/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph.annotations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.json.stream.JsonGenerator;
import org.af.gMCP.gui.graph.annotations.Annotation;
import org.af.gMCP.gui.graph.annotations.AnnotationPanel;

public class Ellipse
extends Annotation {
    int width;
    int height;
    Color color = Color.BLUE;

    public Ellipse(int x, int y, int width, int height, AnnotationPanel nl) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.nl = nl;
    }

    public void writeObject(JsonGenerator gen) {
    }

    public Dimension paintObject(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(this.color);
        g.drawOval((int)((double)this.x * this.nl.getZoom()), (int)((double)this.y * this.nl.getZoom()), (int)((double)this.width * this.nl.getZoom()), (int)((double)this.height * this.nl.getZoom()));
        return new Dimension(this.width, this.height);
    }

    public String getLaTeX() {
        return null;
    }

    public Annotation readJSON(String json) {
        return null;
    }

    public boolean inYou(int xP, int yP) {
        double m1 = (double)this.x + (double)this.width / 2.0;
        double m2 = (double)this.y + (double)this.height / 2.0;
        boolean value = false;
        if (this.width == this.height) {
            value = Math.sqrt(((double)xP - m1) * ((double)xP - m1) + ((double)yP - m2) * ((double)yP - m2)) < (double)(this.width / 2);
        } else if (this.width > this.height) {
            double f11 = (double)(this.x + this.width / 2) - Math.sqrt(this.width * this.width / 4 - this.height * this.height / 4);
            double f21 = (double)(this.x + this.width / 2) + Math.sqrt(this.width * this.width / 4 - this.height * this.height / 4);
            double f12 = this.y + this.height / 2;
            double f22 = this.y + this.height / 2;
            value = Math.sqrt(((double)xP - f11) * ((double)xP - f11) + ((double)yP - f12) * ((double)yP - f12)) + Math.sqrt(((double)xP - f21) * ((double)xP - f21) + ((double)yP - f22) * ((double)yP - f22)) < (double)this.width;
        } else {
            double f11 = this.x + this.width / 2;
            double f21 = this.x + this.width / 2;
            double f12 = (double)(this.y + this.height / 2) - Math.sqrt(this.height * this.height / 4 - this.width * this.width / 4);
            double f22 = (double)(this.y + this.height / 2) + Math.sqrt(this.height * this.height / 4 - this.width * this.width / 4);
            value = Math.sqrt(((double)xP - f11) * ((double)xP - f11) + ((double)yP - f12) * ((double)yP - f12)) + Math.sqrt(((double)xP - f21) * ((double)xP - f21) + ((double)yP - f22) * ((double)yP - f22)) < (double)this.height;
        }
        this.color = value ? Color.GREEN : Color.RED;
        return value;
    }
}

