/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.af.gMCP.config.Configuration;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class LaTeXTool {
    public static Component panel = new JPanel();

    public static String StringToLaTeX(String s) {
        String latex = "";
        if (s.indexOf("E-") != -1) {
            latex = s.replaceAll("E-", "}{10^{");
            latex = "\\frac{" + latex + "}}";
        } else {
            int openBracket = 0;
            boolean waitingForDenominator = false;
            String nominator = "";
            s.replaceAll("\u03b5", "\\varepsilon");
            s.replaceAll(" ", "");
            for (int i = 0; i < s.length(); ++i) {
                String c = "" + s.charAt(i);
                if (c.equals("(")) {
                    ++openBracket;
                }
                if (c.equals(")")) {
                    --openBracket;
                }
                if ((c.equals("+") || c.equals("-") || c.equals("*") || c.equals(")") && i + 1 < s.length() && !(s.charAt(i + 1) + "").equals("/")) && openBracket == 0) {
                    String start = s.substring(0, i + 1);
                    if (waitingForDenominator) {
                        latex = c.equals(")") ? latex + "\\frac{" + nominator + "}{" + start + "}" : latex + "\\frac{" + nominator + "}{" + start.substring(0, i) + "}" + c;
                        waitingForDenominator = false;
                    } else {
                        latex = latex + start;
                    }
                    s = s.substring(i + 1, s.length());
                    i = -1;
                }
                if (!c.equals("/")) continue;
                nominator = s.substring(0, i);
                s = s.substring(i + 1, s.length());
                i = -1;
                waitingForDenominator = true;
            }
            latex = waitingForDenominator ? latex + "\\frac{" + nominator + "}{" + s + "}" : latex + s;
            latex = latex.replaceAll("\\*", Configuration.getInstance().getGeneralConfig().getTimesSymbol());
            latex = latex.replaceAll("\\(", "{(");
            latex = latex.replaceAll("\\)", ")}");
        }
        return latex;
    }

    public static TeXIcon getTeXIcon(JFrame parent, String s, int points) {
        try {
            String latex = LaTeXTool.StringToLaTeX(s);
            TeXFormula formula = new TeXFormula(latex);
            formula = new TeXFormula("\\mathbf{" + latex + "}");
            TeXIcon result = formula.createTeXIcon(2, (float)points);
            if (result.getIconWidth() > 60) {
                result = formula.createTeXIcon(2, (float)((int)((double)points * 0.7)));
            }
            return result;
        }
        catch (Exception e) {
            TeXFormula formula = new TeXFormula("Syntax Error");
            return formula.createTeXIcon(2, (float)((int)((double)points * 0.7)));
        }
    }

    public static void main(String[] args) {
        System.out.println(LaTeXTool.StringToLaTeX("3E-6"));
        System.out.println(LaTeXTool.StringToLaTeX("(1+2\u03b5)/3"));
    }
}

