% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{get_results_records}
\alias{get_results_records}
\title{Retrieve Highbond Results - Records}
\usage{
get_results_records(auth, table_id, timezone = Sys.timezone())
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{table_id}{The table to be downloaded}

\item{timezone}{Defaults to \code{Sys.timezone()}. See \code{OlsonNames()} for a list of allowable timezones.}
}
\value{
A list containing the contents, table requested and the original response
}
\description{
Downloads the content in the structure as saved by Highbond
Results, including metadata and questionnaire responses (if applicable).
}
\details{
Table ID can be found in the path of your Result table.
https://<company_name>.results.highbond.com/projects/<COLLECTION_ID>/controls/<ANALYSIS_ID>/control_tests/<TABLE_ID>
}
\examples{
\dontrun{
response <- get_results_records(auth, 567890)
}
}
