% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{get_fitness}
\alias{get_fitness}
\title{Fitness function}
\usage{
get_fitness(history, agents, payoffs, num_opponents, rounds, useC)
}
\arguments{
\item{history}{A table of all possible prior moves of agents in sequence}

\item{agents}{A list of agents whose fitness will be assessed}

\item{payoffs}{A vector of the payoffs for CC (payoffs[1]), CD (payoffs[2]),
DC (payoffs[3]) and DD (payoffs[4]) combinations of play choices from the
focal player and the opponent}

\item{num_opponents}{The number of random opponents to match the focal agent
against}

\item{rounds}{The number of rounds that will be played}

\item{useC}{A TRUE or FALSE value that determines whether or not c will be
called to calculate agent fitnesses}
}
\value{
fitness A vector in which elements correspond to the accumlated
fitness (payoffs) of each agent
}
\description{
This function assesses the fitness of each strategy through the use of a 
sequential game between each focal strategy and a fixed number of random 
opponents.
}
