% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cred_funs.R
\name{cred_funs}
\alias{cred_funs}
\alias{cred_funs_list}
\alias{cred_funs_add}
\alias{cred_funs_set}
\alias{cred_funs_clear}
\alias{cred_funs_list_default}
\alias{cred_funs_set_default}
\alias{local_cred_funs}
\alias{with_cred_funs}
\title{Credential function registry}
\usage{
cred_funs_list()

cred_funs_add(...)

cred_funs_set(funs, ls = deprecated())

cred_funs_clear()

cred_funs_list_default()

cred_funs_set_default()

local_cred_funs(
  funs = cred_funs_list_default(),
  action = c("replace", "modify"),
  .local_envir = parent.frame()
)

with_cred_funs(
  funs = cred_funs_list_default(),
  code,
  action = c("replace", "modify")
)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> One or more credential
functions, in \code{name = value} form. Each credential function is subject to a
superficial check that it at least "smells like" a credential function: its
first argument must be named \code{scopes}, and its signature must include
\code{...}. To remove a credential function, you can use a specification like
\code{name = NULL}.}

\item{funs}{A named list of credential functions.}

\item{ls}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This argument has been renamed
to \code{funs}.}

\item{action}{Whether to use \code{funs} to replace or modify the registry with
funs:
\itemize{
\item \code{"replace"} does \code{cred_funs_set(funs)}
\item \code{"modify"} does \code{cred_funs_add(!!!funs)}
}}

\item{.local_envir}{The environment to use for scoping. Defaults to current
execution environment.}

\item{code}{Code to run with temporary credential function registry.}
}
\value{
A list of credential functions or \code{NULL}.
}
\description{
Functions to query or manipulate the registry of credential functions
consulted by \code{\link[=token_fetch]{token_fetch()}}.
}
\section{Functions}{
\itemize{
\item \code{cred_funs_list()}: Get the list of registered credential functions.

\item \code{cred_funs_add()}: Register one or more new credential fetching functions.
Function(s) are added to the \emph{front} of the list. So:
\itemize{
\item "First registered, last tried."
\item "Last registered, first tried."
}

Can also be used to \emph{remove} a function from the registry.

\item \code{cred_funs_set()}: Register a list of credential fetching functions.

\item \code{cred_funs_clear()}: Clear the credential function registry.

\item \code{cred_funs_list_default()}: Return the default list of credential functions.

\item \code{cred_funs_set_default()}: Reset the registry to the gargle default.

\item \code{local_cred_funs()}: Modify the credential function registry in the current
scope. It is an example of the \verb{local_*()} functions in \pkg{withr}.

\item \code{with_cred_funs()}: Evaluate \code{code} with a temporarily modified credential
function registry. It is an example of the \verb{with_*()} functions in
\pkg{withr}.

}}
\examples{
names(cred_funs_list())

creds_one <- function(scopes, ...) {}

cred_funs_add(one = creds_one)
cred_funs_add(two = creds_one, three = creds_one)
names(cred_funs_list())

cred_funs_add(two = NULL)
names(cred_funs_list())

# restore the default list
cred_funs_set_default()

# remove one specific credential fetcher
cred_funs_add(credentials_gce = NULL)
names(cred_funs_list())

# force the use of one specific credential fetcher
cred_funs_set(list(credentials_user_oauth2 = credentials_user_oauth2))
names(cred_funs_list())

# restore the default list
cred_funs_set_default()

# run some code with a temporary change to the registry
# creds_one ONLY
with_cred_funs(
  list(one = creds_one),
  names(cred_funs_list())
)
# add creds_one to the list
with_cred_funs(
  list(one = creds_one),
  names(cred_funs_list()),
  action = "modify"
)
# remove credentials_gce
with_cred_funs(
  list(credentials_gce = NULL),
  names(cred_funs_list()),
  action = "modify"
)
}
\seealso{
\code{\link[=token_fetch]{token_fetch()}}, which is where the registry is actually used.
}
