% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_raw_pgram.R
\name{gg_raw_pgram}
\alias{gg_raw_pgram}
\title{Display raw periodogram}
\usage{
gg_raw_pgram(x, k = 1)
}
\arguments{
\item{x}{(num) This should be a numeric vector representing the process to estimate.}

\item{k}{(int) The number of Gegenbauer factors}
}
\value{
A ggplot object representing the raw periodogram
}
\description{
Display the raw periodogram for a time series, and not on a log scale.
}
\details{
The standard "R" functions display periodograms on a log scale which can make it more difficult to locate high peaks in the spectrum at differing frequencies.
This routine will display the peaks on a raw scale.
}
\examples{
data(AirPassengers)
ap <- as.numeric(diff(AirPassengers,12))
sp <- ggbr_semipara(ap)
print(sp)
}
