% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equations.R
\name{recalculate}
\alias{recalculate}
\title{Recalculate gas-exchange data based on a set of equations.}
\usage{
recalculate(df, eqs = NULL)
}
\arguments{
\item{df}{A data frame or an extension thereof (e.g. a tibble).}

\item{eqs}{a list of quosures that define how the df will be altered.}
}
\value{
A tibble with recalculated columns as specified by the eqs
argument
}
\description{
The recalculation uses equations in a list of quosures provided as argument.
This list can be obtained from \code{\link[=create_equations]{create_equations()}} or
\code{\link[=read_6800_equations]{read_6800_equations()}}.
}
\examples{
exampledir <- system.file("extdata", package = "gasanalyzer")
# import factory calibration for example data:
import_factory_cals(exampledir)

# read data:
li6800 <- read_6800_xlsx(paste0(exampledir, "//lowo2.xlsx"))

# recalculate using xlsx equations:
li6800 <- recalculate(li6800)

# recalculate using gasanalyzer default equations for the li6800:
li6800_ge <- recalculate(li6800, create_equations(c("default", "li6800")))

# the difference is that units have been enforced using gasanalyzer, which
# has been recorded in a column:
all.equal(li6800, li6800_ge[names(li6800)], tol = 0.01)
}
