% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{GenAlgControl-class}
\alias{GenAlgControl}
\alias{GenAlgControl-class}
\title{Control class for the genetic algorithm}
\description{
This class controls the general setup of the genetic algorithm
}
\section{Slots}{

\describe{
\item{\code{populationSize}}{The number of "chromosomes" in the population (between 1 and 2^16).}

\item{\code{numGenerations}}{The number of generations to produce (between 1 and 2^16).}

\item{\code{minVariables}}{The minimum number of variables in the variable subset (between 0 and p - 1 where p is the total number of variables).}

\item{\code{maxVariables}}{The maximum number of variables in the variable subset (between 1 and p, and greater than \code{minVariables}).}

\item{\code{elitism}}{The number of absolute best chromosomes to keep across all generations (between 1 and min(\code{populationSize} * \code{numGenerations}, 2^16)).}

\item{\code{mutationProbability}}{The probability of mutation (between 0 and 1).}

\item{\code{badSolutionThreshold}}{The child must not be more than \code{badSolutionThreshold} percent worse than the worse parent. If less than 0, the child must be even better than the worst parent.}

\item{\code{crossover}}{The crossover method to use}

\item{\code{crossoverId}}{The numeric ID of the crossover method to use}

\item{\code{maxDuplicateEliminationTries}}{The maximum number of tries to eliminate duplicates}

\item{\code{verbosity}}{The level of verbosity. 0 means no output at all, 2 is very verbose.}
}}

