% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{lin.fit}
\alias{lin.fit}
\title{Linear concentration - time model}
\usage{
lin.fit(t, C, A = 1, V, serie = "", verbose = TRUE, plot = FALSE, ...)
}
\arguments{
\item{t}{time values (usually in hours)}

\item{C}{concentration values}

\item{A}{area covered by the chamber}

\item{V}{effective volume of the chamber}

\item{serie}{id of the flux measurement}

\item{verbose}{logical, TRUE prints message after each flux calculation}

\item{plot}{logical, mainly intended for use in \code{\link{gasfluxes}}}

\item{\dots}{further parameters, currently none}
}
\value{
A list of
   \item{f0}{flux estimate}
   \item{f0.se}{standard error of flux estimate}
   \item{f0.p}{p-value of flux estimate}
   \item{C0}{estimated concentration at t = 0 (intercept)}  
   \item{AIC}{Akaike information criterion} 
   \item{AICc}{Akaike information criterion with small sample correction}
   \item{RSE}{residual standard error (sigma from summary.nls)}
   \item{r}{Pearson's correlation coefficient}
   \item{diagnostics}{error or warning messages}
}
\description{
Fit a linear model to concentration - time data.
}
\details{
This is basically a wrapper of R's OLS fitting facilities. For now \code{\link{lm}} (and methods for objects of class "lm") is used, 
but this may change to more efficient alternatives in later versions.
}
\examples{
#a single fit
t <- c(0, 1/3, 2/3, 1)
C <- c(320, 341, 352, 359)
print(fit <- lin.fit(t, C, 1, 0.3, "a"))
plot(C ~ t)
curve({fit$f0/0.3 * x + fit$C0}, from = 0, to = 1, add = TRUE)

}
